/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private IWorkspaceRoot fWorkspaceRoot;
    private IDialogSettings fDialogSettings;
    private Control fSWTControl;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDVAR = 2;
    private final int IDX_ADDLIB = 3;
    private final int IDX_ADDFOL = 4;
    private final int IDX_EDIT = 6;
    private final int IDX_REMOVE = 7;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public LibrariesWorkbookPage(IWorkspaceRoot root, ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        this.fWorkspaceRoot = root;
        this.fSWTControl = null;
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        String[] stringArray = new String[8];
        stringArray[0] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addjar.button");
        stringArray[1] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addextjar.button");
        stringArray[2] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addvariable.button");
        stringArray[3] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addlibrary.button");
        stringArray[4] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addclassfolder.button");
        stringArray[6] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.edit.button");
        stringArray[7] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.remove.button");
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.getString("LibrariesWorkbookPage.libraries.label"));
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.enableButton(6, false);
        this.fLibrariesList.setViewerSorter(new CPListElementSorter());
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 6: {
                this.editEntry();
                return;
            }
            case 7: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", this.guessAttachment(curr));
                    curr.setAttribute("javadoc", JavaUI.getLibraryJavadocLocation(curr.getPath()));
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((CPListElementAttribute)elem).getValue() == null : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("sourcepath")) {
            SourceAttachmentDialog dialog;
            CPListElement selElement = elem.getParent();
            IPath containerPath = null;
            boolean applyChanges = false;
            CPListElement parentContainer = selElement.getParentContainer();
            if (parentContainer != null) {
                containerPath = parentContainer.getPath();
                applyChanges = true;
            }
            if ((dialog = new SourceAttachmentDialog(this.getShell(), selElement.getClasspathEntry(), containerPath, this.fCurrJProject, applyChanges)).open() == 0) {
                selElement.setAttribute("sourcepath", dialog.getSourceAttachmentPath());
                this.fLibrariesList.refresh();
                this.fClassPathList.refresh();
            }
        } else if (key.equals("javadoc")) {
            CPListElement selElement = elem.getParent();
            JavadocPropertyDialog dialog = new JavadocPropertyDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("javadoc", dialog.getJavaDocLocation());
                this.fLibrariesList.refresh();
            }
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() == 2) {
                    if (resource.exists()) {
                        res = this.openClassFolderDialog(elem);
                        break;
                    }
                    res = this.openNewClassFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            this.fLibrariesList.replaceElement(elem, res[0]);
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(6, this.canEdit(selElements));
        this.fLibrariesList.enableButton(7, this.canRemove(selElements));
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            return true;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        List projelements = this.fLibrariesList.getElements();
        boolean remove = false;
        List cpelements = this.fClassPathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.NewClassFolderDialog.new.title") : NewWizardMessages.getString("LibrariesWorkbookPage.NewClassFolderDialog.edit.title");
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(NewWizardMessages.getFormattedString("LibrariesWorkbookPage.NewClassFolderDialog.description", projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IFolder;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null);
        Class[] classArray2 = new Class[2];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IProject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("[Lorg.eclipse.core.resources.IFolder;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz3;
        acceptedClasses = classArray2;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, this.getUsedContainers(existing));
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        String title = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.ExistingClassFolderDialog.new.title") : NewWizardMessages.getString("LibrariesWorkbookPage.ExistingClassFolderDialog.edit.title");
        String message = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.ExistingClassFolderDialog.new.description") : NewWizardMessages.getString("LibrariesWorkbookPage.ExistingClassFolderDialog.edit.description");
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (existing == null) {
            dialog.setInitialSelection(this.fCurrJProject.getProject());
        } else {
            dialog.setInitialSelection(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPListElement[] res = new CPListElement[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = this.newCPLibraryElement(elem);
                ++i;
            }
            return res;
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null);
        ArchiveFileFilter filter = new ArchiveFileFilter(this.getUsedJARFiles(existing), true);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        String title = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.JARArchiveDialog.new.title") : NewWizardMessages.getString("LibrariesWorkbookPage.JARArchiveDialog.edit.title");
        String message = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.JARArchiveDialog.new.description") : NewWizardMessages.getString("LibrariesWorkbookPage.JARArchiveDialog.edit.description");
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (existing == null) {
            dialog.setInitialSelection((Object)this.fCurrJProject.getProject());
        } else {
            dialog.setInitialSelection((Object)existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPListElement[] res = new CPListElement[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = this.newCPLibraryElement(elem);
                ++i;
            }
            return res;
        }
        return null;
    }

    private IContainer[] getUsedContainers(CPListElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        if (this.fCurrJProject.exists()) {
            try {
                IResource resource;
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && (resource = this.fWorkspaceRoot.findMember(outputLocation)) instanceof IFolder) {
                    res.add(resource);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource);
            }
            ++i;
        }
        return res.toArray(new IContainer[res.size()]);
    }

    private IFile[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource);
            }
            ++i;
        }
        return res.toArray(new IFile[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        String res;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = existing.getPath().removeLastSegments(1).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.jdt.ui.lastextjar");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.ExtJARArchiveDialog.new.title") : NewWizardMessages.getString("LibrariesWorkbookPage.ExtJARArchiveDialog.edit.title");
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        CPListElement[] elems = new CPListElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            elems[i] = new CPListElement(this.fCurrJProject, 1, path, null);
            ++i;
        }
        this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", filterPath.toOSString());
        return elems;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        if (existing == null) {
            NewVariableEntryDialog dialog = new NewVariableEntryDialog(this.getShell());
            dialog.setTitle(NewWizardMessages.getString("LibrariesWorkbookPage.VariableSelectionDialog.new.title"));
            if (dialog.open() == 0) {
                List existingElements = this.fLibrariesList.getElements();
                IPath[] paths = dialog.getResult();
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i = 0;
                while (i < paths.length) {
                    CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i], null);
                    IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            CPListElement elem;
            List existingElements = this.fLibrariesList.getElements();
            ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
            int i = 0;
            while (i < existingElements.size()) {
                elem = (CPListElement)existingElements.get(i);
                if (elem.getEntryKind() == 4) {
                    existingPaths.add(elem.getPath());
                }
                ++i;
            }
            EditVariableEntryDialog dialog = new EditVariableEntryDialog(this.getShell(), existing.getPath(), existingPaths);
            dialog.setTitle(NewWizardMessages.getString("LibrariesWorkbookPage.VariableSelectionDialog.edit.title"));
            if (dialog.open() == 0) {
                elem = new CPListElement(this.fCurrJProject, 4, dialog.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        String title;
        IClasspathEntry elem = null;
        if (existing == null) {
            title = NewWizardMessages.getString("LibrariesWorkbookPage.ContainerDialog.new.title");
        } else {
            title = NewWizardMessages.getString("LibrariesWorkbookPage.ContainerDialog.edit.title");
            elem = existing.getClasspathEntry();
        }
        return this.openContainerDialog(title, new ClasspathContainerWizard(elem, this.fCurrJProject, this.getRawClasspath()));
    }

    private CPListElement[] openContainerDialog(String title, ClasspathContainerWizard wizard) {
        CPListElement elem;
        IClasspathEntry created;
        wizard.setWindowTitle(title);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)this.getShell());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(40), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        if (dialog.open() == 0 && (created = wizard.getNewEntry()) != null && (elem = new CPListElement(this.fCurrJProject, 5, created.getPath(), null)) != null) {
            return new CPListElement[]{elem};
        }
        return null;
    }

    private IPath guessAttachment(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        try {
            IJavaModel jmodel = this.fCurrJProject.getJavaModel();
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaProject curr = jprojects[i];
                if (!curr.equals(this.fCurrJProject)) {
                    IClasspathEntry[] entries = curr.getRawClasspath();
                    int k = 0;
                    while (k < entries.length) {
                        IPath attachPath;
                        IClasspathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath()) && (attachPath = entry.getSourceAttachmentPath()) != null && !attachPath.isEmpty()) {
                            return attachPath;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }

    private class JavadocPropertyDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private JavadocConfigurationBlock fJavadocConfigurationBlock;

        public JavadocPropertyDialog(Shell parent, CPListElement element) {
            super(parent);
            this.setTitle(NewWizardMessages.getFormattedString("LibrariesWorkbookPage.JavadocPropertyDialog.title", element.getPath().toString()));
            URL initialLocation = JavaUI.getLibraryJavadocLocation(element.getPath());
            this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(parent, this, initialLocation, false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control inner = this.fJavadocConfigurationBlock.createContents(composite);
            inner.setLayoutData((Object)new GridData(1808));
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        public URL getJavaDocLocation() {
            return this.fJavadocConfigurationBlock.getJavadocLocation();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.javadoc_property_dialog_context");
        }
    }
}

