/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationWizardPage
extends JavaCapabilityConfigurationPage {
    private WizardNewProjectCreationPage fMainPage;
    private IPath fCurrProjectLocation;
    protected IProject fCurrProject;
    protected boolean fCanRemoveContent;

    public NewProjectCreationWizardPage(WizardNewProjectCreationPage mainPage) {
        this.fMainPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fCanRemoveContent = false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        IProject newProjectHandle = this.fMainPage.getProjectHandle();
        IPath newProjectLocation = this.fMainPage.getLocationPath();
        this.fCanRemoveContent = this.fMainPage.useDefaults() ? !newProjectLocation.append(this.fMainPage.getProjectName()).toFile().exists() : !newProjectLocation.toFile().exists();
        final boolean initialize = !newProjectHandle.equals((Object)this.fCurrProject) || !newProjectLocation.equals((Object)this.fCurrProjectLocation);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    NewProjectCreationWizardPage.this.updateProject(initialize, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString("NewProjectCreationWizardPage.EarlyCreationOperation.error.title");
            String message = NewWizardMessages.getString("NewProjectCreationWizardPage.EarlyCreationOperation.error.desc");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateProject(boolean initialize, IProgressMonitor monitor) throws CoreException, InterruptedException {
        boolean noProgressMonitor;
        this.fCurrProject = this.fMainPage.getProjectHandle();
        this.fCurrProjectLocation = this.fMainPage.getLocationPath();
        boolean bl = noProgressMonitor = !initialize && this.fCanRemoveContent;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.getString("NewProjectCreationWizardPage.EarlyCreationOperation.desc"), 2);
            JavaCapabilityConfigurationPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (initialize) {
                IClasspathEntry[] entries = null;
                IPath outputLocation = null;
                if (this.fCurrProjectLocation.toFile().exists() && !Platform.getLocation().equals((Object)this.fCurrProjectLocation) && !this.fCurrProject.getFile(".classpath").exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject);
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                }
                this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            }
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.getString("NewProjectCreationWizardPage.createproject.desc"), 3);
            if (this.fCurrProject == null) {
                this.updateProject(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            this.fCurrProject = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
        this.fCurrProject = null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean noProgressMonitor = Platform.getLocation().equals((Object)NewProjectCreationWizardPage.this.fCurrProjectLocation);
                if (monitor == null || noProgressMonitor) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString("NewProjectCreationWizardPage.removeproject.desc"), 3);
                try {
                    try {
                        NewProjectCreationWizardPage.this.fCurrProject.delete(NewProjectCreationWizardPage.this.fCanRemoveContent, false, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    NewProjectCreationWizardPage.this.fCurrProject = null;
                    NewProjectCreationWizardPage.this.fCanRemoveContent = false;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
                NewProjectCreationWizardPage.this.fCurrProject = null;
                NewProjectCreationWizardPage.this.fCanRemoveContent = false;
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString("NewProjectCreationWizardPage.op_error.title");
            String message = NewWizardMessages.getString("NewProjectCreationWizardPage.op_error_remove.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void performCancel() {
        this.removeProject();
    }
}

