/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map fListenerGroups = new HashMap();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    public void addListener(IEditorPart part, ISelectionListenerWithAST listener) {
        ISelectionService service = part.getSite().getWorkbenchWindow().getSelectionService();
        WorkbenchWindowListener windowListener = (WorkbenchWindowListener)this.fListenerGroups.get(service);
        if (windowListener == null) {
            windowListener = new WorkbenchWindowListener(service);
            this.fListenerGroups.put(service, windowListener);
        }
        windowListener.install(part, listener);
    }

    public void removeListener(IEditorPart part, ISelectionListenerWithAST listener) {
        ISelectionService service = part.getSite().getWorkbenchWindow().getSelectionService();
        WorkbenchWindowListener windowListener = (WorkbenchWindowListener)this.fListenerGroups.get(service);
        if (windowListener != null) {
            windowListener.uninstall(part, listener);
            if (windowListener.isEmpty()) {
                this.fListenerGroups.remove(service);
            }
        }
    }

    private static class PartListenerGroup {
        private IEditorPart fPart;
        private Job fCurrentJob;
        private ListenerList fAstListeners;
        static /* synthetic */ Class class$0;

        public PartListenerGroup(IEditorPart part) {
            this.fPart = part;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList();
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            this.fAstListeners.remove((Object)listener);
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
                this.fCurrentJob = null;
            }
            this.fCurrentJob = new Job(this, JavaUIMessages.getString("SelectionListenerWithASTManager.job.title"), selection){
                final /* synthetic */ PartListenerGroup this$1;
                private final /* synthetic */ ITextSelection val$selection;
                {
                    this.this$1 = partListenerGroup;
                    this.val$selection = iTextSelection;
                }

                public IStatus run(IProgressMonitor monitor) {
                    PartListenerGroup partListenerGroup = this.this$1;
                    synchronized (partListenerGroup) {
                        if (this != PartListenerGroup.access$0(this.this$1)) {
                            return Status.OK_STATUS;
                        }
                        this.this$1.calculateASTandInform(this.val$selection);
                        return Status.OK_STATUS;
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.schedule();
        }

        private CompilationUnit computeAST() {
            IEditorInput editorInput = this.fPart.getEditorInput();
            if (editorInput != null) {
                IJavaElement element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IJavaElement)editorInput.getAdapter((Class)clazz)) instanceof ICompilationUnit) {
                    return AST.parseCompilationUnit((ICompilationUnit)((ICompilationUnit)element), (boolean)true);
                }
                if (element instanceof IClassFile) {
                    return AST.parseCompilationUnit((IClassFile)((IClassFile)element), (boolean)true);
                }
            }
            return null;
        }

        protected void calculateASTandInform(ITextSelection selection) {
            CompilationUnit astRoot = this.computeAST();
            if (astRoot != null) {
                Object[] listeners = this.fAstListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((ISelectionListenerWithAST)listeners[i]).selectionChanged(this.fPart, selection, astRoot);
                    ++i;
                }
            }
        }

        static /* synthetic */ Job access$0(PartListenerGroup partListenerGroup) {
            return partListenerGroup.fCurrentJob;
        }
    }

    private static class WorkbenchWindowListener
    implements ISelectionListener {
        private ISelectionService fSelectionService;
        private Map fPartListeners;

        public WorkbenchWindowListener(ISelectionService service) {
            this.fSelectionService = service;
            this.fPartListeners = new HashMap();
        }

        public boolean isEmpty() {
            return this.fPartListeners.isEmpty();
        }

        public void install(IEditorPart part, ISelectionListenerWithAST listener) {
            PartListenerGroup listenerGroup;
            if (this.fPartListeners.isEmpty()) {
                this.fSelectionService.addPostSelectionListener((ISelectionListener)this);
            }
            if ((listenerGroup = (PartListenerGroup)this.fPartListeners.get(part)) == null) {
                listenerGroup = new PartListenerGroup(part);
                this.fPartListeners.put(part, listenerGroup);
            }
            listenerGroup.install(listener);
        }

        public void uninstall(IEditorPart part, ISelectionListenerWithAST listener) {
            PartListenerGroup listenerGroup = (PartListenerGroup)this.fPartListeners.get(part);
            if (listenerGroup == null) {
                return;
            }
            listenerGroup.uninstall(listener);
            if (listenerGroup.isEmpty()) {
                this.fPartListeners.remove(part);
                if (this.fPartListeners.isEmpty()) {
                    this.fSelectionService.removePostSelectionListener((ISelectionListener)this);
                }
            }
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            PartListenerGroup listenerGroup;
            if (part instanceof IEditorPart && selection instanceof ITextSelection && (listenerGroup = (PartListenerGroup)this.fPartListeners.get(part)) != null) {
                listenerGroup.fireSelectionChanged((ITextSelection)selection);
            }
        }
    }
}

