/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ProblemTableViewer
extends TableViewer {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTableViewer(Composite parent) {
        super(parent);
        this.initMapper();
    }

    public ProblemTableViewer(Composite parent, int style) {
        super(parent, style);
        this.initMapper();
    }

    public ProblemTableViewer(Table table) {
        super(table);
        this.initMapper();
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper((ContentViewer)this);
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && !this.isShowingWorkingCopies()) {
            return;
        }
        Object[] changed = event.getElements();
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>(changed.length);
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        ISelection validNewSelection = this.getValidSelection(newSelection);
        if (this.getComparer() == null && this.isShowingWorkingCopies() && invalidSelection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)invalidSelection;
            ArrayList<IJavaElement> elementsToSelect = new ArrayList<IJavaElement>(structSel.size());
            Iterator iter = structSel.iterator();
            while (iter.hasNext()) {
                IJavaElement je;
                Object element = iter.next();
                if (!(element instanceof IJavaElement) || (je = this.convertToValidElement((IJavaElement)element)) == null) continue;
                elementsToSelect.add(je);
            }
            if (!elementsToSelect.isEmpty()) {
                List alreadySelected = SelectionUtil.toList(validNewSelection);
                if (alreadySelected != null && !alreadySelected.isEmpty()) {
                    elementsToSelect.addAll(SelectionUtil.toList(validNewSelection));
                }
                validNewSelection = new StructuredSelection(elementsToSelect);
            }
        }
        if (validNewSelection != newSelection) {
            this.setSelection(validNewSelection);
        }
        super.handleInvalidSelection(invalidSelection, validNewSelection);
    }

    private ISelection getValidSelection(ISelection selection) {
        List selectedElements = SelectionUtil.toList(selection);
        if (selectedElements == null || selectedElements.isEmpty()) {
            return selection;
        }
        boolean selectionChanged = false;
        ArrayList<Object> validElementsToSelect = new ArrayList<Object>(selectedElements.size());
        Iterator iter = selectedElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IJavaElement) {
                IJavaElement je = (IJavaElement)element;
                if (je != null && je.exists()) {
                    validElementsToSelect.add(je);
                    continue;
                }
                selectionChanged = true;
                continue;
            }
            validElementsToSelect.add(element);
        }
        if (selectionChanged) {
            return new StructuredSelection(validElementsToSelect);
        }
        return selection;
    }

    private IJavaElement convertToValidElement(IJavaElement je) {
        ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
        IJavaElement convertedJE = null;
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            convertedJE = cu.getOriginal(je);
        } else {
            IJavaElement[] matches;
            ICompilationUnit wc = EditorUtility.getWorkingCopy(cu);
            if (wc != null && (matches = wc.findElements(je)) != null && matches.length > 0) {
                convertedJE = matches[0];
            }
        }
        if (convertedJE != null && convertedJE.exists()) {
            return convertedJE;
        }
        return null;
    }

    private boolean isShowingWorkingCopies() {
        IContentProvider contentProvider = this.getContentProvider();
        return contentProvider instanceof IWorkingCopyProvider && ((IWorkingCopyProvider)contentProvider).providesWorkingCopies();
    }
}

