/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;

public class MainMethodSearchEngine {
    public IType[] searchMainMethods(IProgressMonitor pm, IJavaSearchScope scope, int style) throws JavaModelException {
        ArrayList typesFound = new ArrayList(200);
        MethodCollector collector = new MethodCollector(typesFound, style, pm);
        new SearchEngine().search(JavaPlugin.getWorkspace(), "main(String[]) void", 1, 0, scope, (IJavaSearchResultCollector)collector);
        return typesFound.toArray(new IType[typesFound.size()]);
    }

    public IType[] searchMainMethods(IRunnableContext context, final IJavaSearchScope scope, final int style) throws InvocationTargetException, InterruptedException {
        int allFlags = 24;
        Assert.isTrue(((style | allFlags) == allFlags ? 1 : 0) != 0);
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    res[0] = MainMethodSearchEngine.this.searchMainMethods(pm, scope, style);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private static class MethodCollector
    implements IJavaSearchResultCollector {
        private List fResult;
        private int fStyle;
        private IProgressMonitor fProgressMonitor;

        public MethodCollector(List result, int style, IProgressMonitor progressMonitor) {
            Assert.isNotNull((Object)result);
            this.fResult = result;
            this.fStyle = style;
            this.fProgressMonitor = progressMonitor;
        }

        private boolean considerExternalJars() {
            return (this.fStyle & 0x10) != 0;
        }

        private boolean considerBinaries() {
            return (this.fStyle & 8) != 0;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
            if (enclosingElement instanceof IMethod) {
                try {
                    IMethod curr = (IMethod)enclosingElement;
                    if (curr.isMainMethod()) {
                        IPackageFragmentRoot root;
                        if (!this.considerExternalJars() && ((root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)curr)) == null || root.isArchive())) {
                            return;
                        }
                        if (!this.considerBinaries() && curr.isBinary()) {
                            return;
                        }
                        this.fResult.add(curr.getDeclaringType());
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                }
            }
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public void aboutToStart() {
        }

        public void done() {
        }
    }
}

