/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IJavaElement fInputElement = null;
    private boolean fIsSuperTypesOnly;
    private boolean fReconciled;
    private List fChangeListeners;

    public TypeHierarchyLifeCycle() {
        this(false);
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
        this.fIsSuperTypesOnly = isSuperTypesOnly;
        this.fChangeListeners = new ArrayList(2);
        this.fReconciled = false;
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IJavaElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(IType[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(final IJavaElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        if (element == null || !element.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(element, pm);
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            context.run(true, true, op);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private void doHierarchyRefresh(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                this.fHierarchy = this.fIsSuperTypesOnly ? type.newSupertypeHierarchy(pm) : type.newTypeHierarchy(pm);
            } else {
                IPackageFragmentRoot[] roots;
                IRegion region = JavaCore.newRegion();
                if (element.getElementType() == 2) {
                    roots = ((IJavaProject)element).getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        if (!roots[i].isExternal()) {
                            region.add((IJavaElement)roots[i]);
                        }
                        ++i;
                    }
                } else if (element.getElementType() == 4) {
                    roots = element.getJavaProject().getPackageFragmentRoots();
                    String name = element.getElementName();
                    int i = 0;
                    while (i < roots.length) {
                        IPackageFragment pack = roots[i].getPackageFragment(name);
                        if (pack.exists()) {
                            region.add((IJavaElement)pack);
                        }
                        ++i;
                    }
                } else {
                    region.add(element);
                }
                IJavaProject jproject = element.getJavaProject();
                this.fHierarchy = jproject.newTypeHierarchy(region, pm);
            }
            this.fInputElement = element;
        } else {
            this.fHierarchy.refresh(pm);
        }
        this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        IJavaElement elem = event.getDelta().getElement();
        if (!this.isReconciled() && elem instanceof IWorkingCopy && ((IWorkingCopy)elem).isWorkingCopy()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new IType[changedTypes.size()]));
        }
    }

    private void processDelta(IJavaElementDelta delta, ArrayList changedTypes) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 7: {
                this.processTypeDelta((IType)element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 5: {
                ICompilationUnit cu = (ICompilationUnit)element;
                if (!JavaModelUtil.isPrimary(cu)) {
                    return;
                }
                boolean isWorkingCopyRemove = this.isWorkingCopyRemove(cu, delta.getKind());
                if (isWorkingCopyRemove || delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    try {
                        if (isWorkingCopyRemove) {
                            cu = JavaModelUtil.toOriginal(cu);
                        }
                        if (!cu.exists()) break;
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.processTypeDelta(types[i], changedTypes);
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 6: {
                if (delta.getKind() == 4) {
                    try {
                        IType type = ((IClassFile)element).getType();
                        this.processTypeDelta(type, changedTypes);
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x4001) == 1;
    }

    private boolean isWorkingCopyRemove(ICompilationUnit cu, int deltaKind) {
        return this.isReconciled() && deltaKind == 2 && cu.isWorkingCopy();
    }

    private void processTypeDelta(IType type, ArrayList changedTypes) {
        type = (IType)JavaModelUtil.toOriginal((IMember)type);
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(IJavaElementDelta delta, ArrayList changedTypes) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }

    public boolean isReconciled() {
        return this.fReconciled;
    }

    public void setReconciled(boolean reconciled) {
        this.fReconciled = reconciled;
    }
}

