/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
    }

    public void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return this.fTypeHierarchy.isReconciled();
    }

    public Object[] getElements(Object parent) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            return new IType[]{input};
        }
        return NO_ELEMENTS;
    }

    protected abstract IType[] getTypesInHierarchy(IType var1);

    protected abstract IType getParentType(IType var1);

    private boolean isInWorkingSet(Object element) {
        return this.fWorkingSetFilter == null || this.fWorkingSetFilter.select(null, null, element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            IType[] childrenTypes = this.getTypesInHierarchy(type);
            ArrayList children = new ArrayList();
            if (this.fMemberFilter != null) {
                this.addFilteredMembers(type, children);
            }
            this.addFilteredTypes(childrenTypes, children);
            return children.toArray();
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            try {
                return this.hasFilteredChildren((IType)element);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMembers(IType parent, List children) {
        try {
            IMethod[] methods = parent.getMethods();
            int i = 0;
            while (i < this.fMemberFilter.length) {
                IMethod curr;
                IMethod meth;
                IMember member = this.fMemberFilter[i];
                if (parent.equals(member.getDeclaringType())) {
                    if (!children.contains(member)) {
                        children.add(member);
                    }
                } else if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null && !children.contains(meth)) {
                    children.add(meth);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private void addFilteredTypes(IType[] types, List children) {
        try {
            int i = 0;
            while (i < types.length) {
                if (this.hasFilteredChildren(types[i])) {
                    children.add(types[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean hasFilteredChildren(IType type) throws JavaModelException {
        int i;
        if (this.isInWorkingSet(type)) {
            if (this.fMemberFilter != null) {
                IMethod[] methods = type.getMethods();
                i = 0;
                while (i < this.fMemberFilter.length) {
                    IMethod curr;
                    IMethod meth;
                    IMember member = this.fMemberFilter[i];
                    if (type.equals(member.getDeclaringType())) {
                        return true;
                    }
                    if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null) {
                        return true;
                    }
                    ++i;
                }
            } else {
                return true;
            }
        }
        IType[] childrenTypes = this.getTypesInHierarchy(type);
        i = 0;
        while (i < childrenTypes.length) {
            if (this.hasFilteredChildren(childrenTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                return this.getParentType((IType)member);
            }
            return member.getDeclaringType();
        }
        return null;
    }
}

