/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class TraditionalHierarchyViewer
extends TypeHierarchyViewer {
    public TraditionalHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part) {
        super(parent, (IContentProvider)new TraditionalHierarchyContentProvider(lifeCycle), lifeCycle, part);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.getString("TraditionalHierarchyViewer.filtered.title");
        }
        return TypeHierarchyMessages.getString("TraditionalHierarchyViewer.title");
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            TraditionalHierarchyContentProvider contentProvider = (TraditionalHierarchyContentProvider)this.getContentProvider();
            int expandLevel = contentProvider.getExpandLevel();
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class TraditionalHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public TraditionalHierarchyContentProvider(TypeHierarchyLifeCycle provider) {
            super(provider);
        }

        public int getExpandLevel() {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input != null) {
                    return this.getDepth(hierarchy, input) + 2;
                }
                return 5;
            }
            return 2;
        }

        private int getDepth(ITypeHierarchy hierarchy, IType input) {
            int count = 0;
            IType superType = hierarchy.getSuperclass(input);
            while (superType != null) {
                ++count;
                superType = hierarchy.getSuperclass(superType);
            }
            return count;
        }

        public Object[] getElements(Object parent) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input == null) {
                    return hierarchy.getRootClasses();
                }
                if (Flags.isInterface((int)hierarchy.getCachedFlags(input))) {
                    return new Object[]{input};
                }
                Object[] roots = hierarchy.getRootClasses();
                int i = 0;
                while (i < roots.length) {
                    if ("java.lang.Object".equals(JavaModelUtil.getFullyQualifiedName((IType)roots[i]))) {
                        return new Object[]{roots[i]};
                    }
                    ++i;
                }
                return roots;
            }
            return TypeHierarchyContentProvider.NO_ELEMENTS;
        }

        protected final IType[] getTypesInHierarchy(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSubtypes(type);
            }
            return new IType[0];
        }

        protected IType getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

