/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.viewers.Viewer;

public class HierarchyViewerSorter
extends JavaElementSorter {
    private TypeHierarchyLifeCycle fHierarchy;
    private boolean fSortByDefiningType;

    public HierarchyViewerSorter(TypeHierarchyLifeCycle cycle) {
        this.fHierarchy = cycle;
    }

    public int category(Object element) {
        int cat = super.category(element);
        if (element instanceof IType) {
            IType type;
            ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
            cat += 20;
            if (hierarchy != null && Flags.isInterface((int)hierarchy.getCachedFlags(type = (IType)JavaModelUtil.toOriginal((IMember)((IType)element))))) {
                ++cat;
            }
        }
        return cat;
    }

    public boolean isSortByDefiningType() {
        return this.fSortByDefiningType;
    }

    public void setSortByDefiningType(boolean sortByDefiningType) {
        this.fSortByDefiningType = sortByDefiningType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (!this.fSortByDefiningType || hierarchy == null) return super.compare(viewer, e1, e2);
        try {
            IType def2;
            IType def1 = e1 instanceof IMethod ? this.getDefiningType(hierarchy, (IMethod)e1) : null;
            IType iType = def2 = e2 instanceof IMethod ? this.getDefiningType(hierarchy, (IMethod)e2) : null;
            if (def1 != null) {
                if (def2 == null) return -1;
                if (def2.equals(def1)) return super.compare(viewer, e1, e2);
                return this.compareInHierarchy(hierarchy, def1, def2);
            } else {
                if (def2 == null) return super.compare(viewer, e1, e2);
                return 1;
            }
        }
        catch (JavaModelException javaModelException) {}
        return super.compare(viewer, e1, e2);
    }

    private IType getDefiningType(ITypeHierarchy hierarchy, IMethod method) throws JavaModelException {
        IType declaringType = (IType)JavaModelUtil.toOriginal((IMember)method.getDeclaringType());
        int flags = method.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || method.isConstructor()) {
            return null;
        }
        IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, declaringType, method.getElementName(), method.getParameterTypes(), false);
        if (res == null || method.equals(res)) {
            return null;
        }
        return res.getDeclaringType();
    }

    private int compareInHierarchy(ITypeHierarchy hierarchy, IType def1, IType def2) {
        if (this.isSuperType(hierarchy, def1, def2)) {
            return 1;
        }
        if (this.isSuperType(hierarchy, def2, def1)) {
            return -1;
        }
        int flags1 = hierarchy.getCachedFlags(def1);
        int flags2 = hierarchy.getCachedFlags(def2);
        if (Flags.isInterface((int)flags1)) {
            if (!Flags.isInterface((int)flags2)) {
                return 1;
            }
        } else if (Flags.isInterface((int)flags2)) {
            return -1;
        }
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getCollator().compare(name1, name2);
    }

    private boolean isSuperType(ITypeHierarchy hierarchy, IType def1, IType def2) {
        IType superType = hierarchy.getSuperclass(def1);
        if (superType != null && (superType.equals(def2) || this.isSuperType(hierarchy, superType, def2))) {
            return true;
        }
        IType[] superInterfaces = hierarchy.getAllSuperInterfaces(def1);
        int i = 0;
        while (i < superInterfaces.length) {
            IType curr = superInterfaces[i];
            if (curr.equals(def2) || this.isSuperType(hierarchy, curr, def2)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

