/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyLabelProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.jdt.internal.ui.typehierarchy.SuperTypeHierarchyViewer;
import org.eclipse.jdt.internal.ui.typehierarchy.TraditionalHierarchyViewer;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.keys.CharacterKey;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ModifierKey;
import org.eclipse.ui.keys.NaturalKey;
import org.eclipse.ui.keys.SpecialKey;

public class HierarchyInformationControl
extends AbstractInformationControl {
    private TypeHierarchyLifeCycle fLifeCycle;
    private HierarchyLabelProvider fLabelProvider;
    private Label fHeaderLabel;
    private Label fStatusTextLabel;
    private Font fStatusTextFont;
    private KeyAdapter fKeyAdapter;
    private Object[] fOtherExpandedElements = null;
    private TypeHierarchyContentProvider fOtherContentProvider;
    private IMethod fFocus;
    private boolean fDoFilter = true;
    private KeySequence[] fKeySequences = null;

    public HierarchyInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle);
    }

    private KeySequence[] getKeySequences() {
        if (this.fKeySequences == null) {
            List list;
            ICommandManager commandManager = PlatformUI.getWorkbench().getCommandManager();
            ICommand command = commandManager.getCommand("org.eclipse.jdt.ui.edit.text.java.open.hierarchy");
            if (command.isDefined() && !(list = command.getKeySequenceBindings()).isEmpty()) {
                this.fKeySequences = new KeySequence[list.size()];
                int i = 0;
                while (i < this.fKeySequences.length) {
                    this.fKeySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                    ++i;
                }
                return this.fKeySequences;
            }
            this.fKeySequences = new KeySequence[]{KeySequence.getInstance((KeyStroke)KeyStroke.getInstance((NaturalKey)SpecialKey.F12))};
        }
        return this.fKeySequences;
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = HierarchyInformationControl.this.convertEventToUnmodifiedAccelerator(e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)HierarchyInformationControl.this.convertAcceleratorToKeyStroke(accelerator));
                    KeySequence[] sequences = HierarchyInformationControl.this.getKeySequences();
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            HierarchyInformationControl.this.toggleHierarchy();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected Text createFilterText(Composite parent) {
        this.fHeaderLabel = new Label(parent, 0);
        this.fHeaderLabel.setLayoutData((Object)new GridData(768));
        this.fHeaderLabel.setFont(JFaceResources.getBannerFont());
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        tree.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IType;
            }
        });
        this.fLifeCycle = new TypeHierarchyLifeCycle(false);
        treeViewer.setSorter((ViewerSorter)new HierarchyViewerSorter(this.fLifeCycle));
        treeViewer.setAutoExpandLevel(-1);
        this.fLabelProvider = new HierarchyLabelProvider(this.fLifeCycle);
        this.fLabelProvider.setFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return HierarchyInformationControl.this.hasFocusMethod((IType)element);
            }
        });
        this.fLabelProvider.setTextFlags(32769);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, true, false));
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label separator = new Label(composite, 259);
        separator.setLayoutData((Object)new GridData(768));
        this.fStatusTextLabel = new Label(parent, 131072);
        this.fStatusTextLabel.setLayoutData((Object)new GridData(768));
        this.fStatusTextLabel.setText(this.getInfoLabel());
        Font font = this.fStatusTextLabel.getFont();
        Display display = parent.getDisplay();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        this.fStatusTextFont = new Font((Device)display, fontDatas);
        this.fStatusTextLabel.setFont(this.fStatusTextFont);
        this.fStatusTextLabel.setForeground(display.getSystemColor(17));
        return treeViewer;
    }

    protected boolean hasFocusMethod(IType type) {
        if (this.fFocus == null) {
            return true;
        }
        IMethod[] methods = type.findMethods(this.fFocus);
        if (methods != null && methods.length > 0) {
            try {
                IPackageFragment pack = (IPackageFragment)this.fFocus.getAncestor(4);
                int i = 0;
                while (i < methods.length) {
                    IMethod curr = methods[i];
                    if (JavaModelUtil.isVisibleInHierarchy((IMember)curr, pack)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.fHeaderLabel.setForeground(foreground);
        this.fStatusTextLabel.getParent().setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.fHeaderLabel.setBackground(background);
        this.fStatusTextLabel.setBackground(background);
        this.fStatusTextLabel.getParent().setBackground(background);
    }

    public void dispose() {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        super.dispose();
    }

    public void setInput(Object information) {
        IMember[] iMemberArray;
        if (!(information instanceof IJavaElement)) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement input = null;
        IMethod locked = null;
        try {
            IJavaElement elem = (IJavaElement)information;
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    input = elem;
                    break;
                }
                case 5: {
                    input = ((ICompilationUnit)elem).findPrimaryType();
                    break;
                }
                case 6: {
                    input = ((IClassFile)elem).getType();
                    break;
                }
                case 9: {
                    IMethod method = (IMethod)elem;
                    if (!method.isConstructor()) {
                        locked = method;
                    }
                    input = method.getDeclaringType();
                    break;
                }
                case 8: 
                case 10: {
                    input = ((IMember)elem).getDeclaringType();
                    break;
                }
                case 11: {
                    input = elem.getParent().getParent();
                    break;
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    if (decl.isOnDemand()) {
                        input = JavaModelUtil.findTypeContainer(decl.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                        break;
                    }
                    input = decl.getJavaProject().findType(decl.getElementName());
                    break;
                }
                default: {
                    input = null;
                    break;
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        this.fHeaderLabel.setText(this.getHeaderLabel((IJavaElement)(locked == null ? input : locked)));
        try {
            this.fLifeCycle.ensureRefreshedTypeHierarchy(input, (IRunnableContext)JavaPlugin.getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException invocationTargetException) {
            input = null;
        }
        catch (InterruptedException interruptedException) {
            this.dispose();
            return;
        }
        if (locked != null) {
            IMember[] iMemberArray2 = new IMember[1];
            iMemberArray = iMemberArray2;
            iMemberArray2[0] = locked;
        } else {
            iMemberArray = null;
        }
        IMember[] memberFilter = iMemberArray;
        TraditionalHierarchyViewer.TraditionalHierarchyContentProvider contentProvider = new TraditionalHierarchyViewer.TraditionalHierarchyContentProvider(this.fLifeCycle);
        contentProvider.setMemberFilter(memberFilter);
        this.getTreeViewer().setContentProvider((IContentProvider)contentProvider);
        this.fOtherContentProvider = new SuperTypeHierarchyViewer.SuperTypeHierarchyContentProvider(this.fLifeCycle);
        this.fOtherContentProvider.setMemberFilter(memberFilter);
        this.fFocus = locked;
        Object[] topLevelObjects = contentProvider.getElements(this.fLifeCycle);
        if (topLevelObjects.length > 0 && contentProvider.getChildren(topLevelObjects[0]).length > 40) {
            this.fDoFilter = false;
        } else {
            this.getTreeViewer().addFilter((ViewerFilter)new AbstractInformationControl.NamePatternFilter());
        }
        Object selection = null;
        if (input instanceof IMember) {
            selection = input;
        } else if (topLevelObjects.length > 0) {
            selection = topLevelObjects[0];
        }
        this.inputChanged(this.fLifeCycle, selection);
    }

    protected void stringMatcherUpdated() {
        if (this.fDoFilter) {
            super.stringMatcherUpdated();
        } else {
            this.selectFirstMatch();
        }
    }

    protected void toggleHierarchy() {
        TreeViewer treeViewer = this.getTreeViewer();
        Object[] expandedElements = treeViewer.getExpandedElements();
        TypeHierarchyContentProvider contentProvider = (TypeHierarchyContentProvider)treeViewer.getContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.fOtherContentProvider);
        treeViewer.refresh();
        if (this.fOtherExpandedElements != null) {
            treeViewer.setExpandedElements(this.fOtherExpandedElements);
        } else {
            treeViewer.expandAll();
        }
        this.fOtherContentProvider = contentProvider;
        this.fOtherExpandedElements = expandedElements;
        this.fStatusTextLabel.setText(this.getInfoLabel());
    }

    private String getHeaderLabel(IJavaElement input) {
        if (input instanceof IMethod) {
            Object[] args = new String[]{input.getParent().getElementName(), JavaElementLabels.getElementLabel(input, 1)};
            return TypeHierarchyMessages.getFormattedString("HierarchyInformationControl.methodhierarchy.label", args);
        }
        String arg = JavaElementLabels.getElementLabel(input, 1386656);
        return TypeHierarchyMessages.getFormattedString("HierarchyInformationControl.hierarchy.label", arg);
    }

    private String getInfoLabel() {
        KeySequence[] sequences = this.getKeySequences();
        String keyName = sequences[0].format();
        if (this.fOtherContentProvider instanceof TraditionalHierarchyViewer.TraditionalHierarchyContentProvider) {
            return TypeHierarchyMessages.getFormattedString("HierarchyInformationControl.toggle.traditionalhierarchy.label", keyName);
        }
        return TypeHierarchyMessages.getFormattedString("HierarchyInformationControl.toggle.superhierarchy.label", keyName);
    }

    protected Object getSelectedElement() {
        IMethod[] methods;
        Object selectedElement = super.getSelectedElement();
        if (selectedElement instanceof IType && this.fFocus != null && (methods = ((IType)selectedElement).findMethods(this.fFocus)) != null && methods.length > 0) {
            return methods[0];
        }
        return selectedElement;
    }

    protected KeyStroke convertAcceleratorToKeyStroke(int accelerator) {
        TreeSet<ModifierKey> modifierKeys = new TreeSet<ModifierKey>();
        SpecialKey naturalKey = null;
        if ((accelerator & 0x10000) != 0) {
            modifierKeys.add(ModifierKey.ALT);
        }
        if ((accelerator & 0x400000) != 0) {
            modifierKeys.add(ModifierKey.COMMAND);
        }
        if ((accelerator & 0x40000) != 0) {
            modifierKeys.add(ModifierKey.CTRL);
        }
        if ((accelerator & 0x20000) != 0) {
            modifierKeys.add(ModifierKey.SHIFT);
        }
        if ((accelerator & 0x100FFFF) == 0 && accelerator != 0) {
            naturalKey = null;
        } else {
            switch (accelerator &= 0x100FFFF) {
                case 0x1000002: {
                    naturalKey = SpecialKey.ARROW_DOWN;
                    break;
                }
                case 0x1000003: {
                    naturalKey = SpecialKey.ARROW_LEFT;
                    break;
                }
                case 0x1000004: {
                    naturalKey = SpecialKey.ARROW_RIGHT;
                    break;
                }
                case 0x1000001: {
                    naturalKey = SpecialKey.ARROW_UP;
                    break;
                }
                case 0x1000008: {
                    naturalKey = SpecialKey.END;
                    break;
                }
                case 0x100000A: {
                    naturalKey = SpecialKey.F1;
                    break;
                }
                case 0x1000013: {
                    naturalKey = SpecialKey.F10;
                    break;
                }
                case 0x1000014: {
                    naturalKey = SpecialKey.F11;
                    break;
                }
                case 0x1000015: {
                    naturalKey = SpecialKey.F12;
                    break;
                }
                case 0x100000B: {
                    naturalKey = SpecialKey.F2;
                    break;
                }
                case 0x100000C: {
                    naturalKey = SpecialKey.F3;
                    break;
                }
                case 0x100000D: {
                    naturalKey = SpecialKey.F4;
                    break;
                }
                case 0x100000E: {
                    naturalKey = SpecialKey.F5;
                    break;
                }
                case 0x100000F: {
                    naturalKey = SpecialKey.F6;
                    break;
                }
                case 0x1000010: {
                    naturalKey = SpecialKey.F7;
                    break;
                }
                case 0x1000011: {
                    naturalKey = SpecialKey.F8;
                    break;
                }
                case 0x1000012: {
                    naturalKey = SpecialKey.F9;
                    break;
                }
                case 0x1000007: {
                    naturalKey = SpecialKey.HOME;
                    break;
                }
                case 0x1000009: {
                    naturalKey = SpecialKey.INSERT;
                    break;
                }
                case 0x1000006: {
                    naturalKey = SpecialKey.PAGE_DOWN;
                    break;
                }
                case 0x1000005: {
                    naturalKey = SpecialKey.PAGE_UP;
                    break;
                }
                default: {
                    naturalKey = CharacterKey.getInstance((char)((char)(accelerator & 0xFFFF)));
                }
            }
        }
        return KeyStroke.getInstance(modifierKeys, naturalKey);
    }

    protected int convertEventToUnmodifiedAccelerator(KeyEvent e) {
        int modifiers = e.stateMask & SWT.MODIFIER_MASK;
        char ch = (char)e.keyCode;
        return modifiers + (Character.isLetter(ch) ? Character.toUpperCase(ch) : ch);
    }
}

