/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionGroup;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIControl;
import org.eclipse.jdt.internal.ui.text.template.TemplateInformationControlCreator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private final IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        Assert.isNotNull(template);
        Assert.isNotNull(context);
        Assert.isNotNull(region);
        this.fTemplate = template;
        this.fContext = context;
        this.fImage = image;
        this.fRegion = region;
        this.fDisplayString = null;
        if (context instanceof JavaContext) {
            switch (((JavaContext)context).getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.fRelevance = 90;
                    break;
                }
                default: {
                    this.fRelevance = 0;
                    break;
                }
            }
        } else {
            this.fRelevance = 90;
        }
    }

    public final void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument document = viewer.getDocument();
            Position position = new Position(this.fRegion.getOffset(), this.fRegion.getLength());
            String category = "__template_position_" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            this.fContext.setReadOnly(false);
            TemplateBuffer templateBuffer = this.fContext.evaluate(this.fTemplate);
            if (templateBuffer == null) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            document.removePosition(position);
            document.removePositionUpdater((IPositionUpdater)updater);
            document.removePositionCategory(category);
            int start = position.getOffset();
            int end = position.getOffset() + position.getLength();
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedEnvironment env = new LinkedEnvironment();
            TemplatePosition[] variables = templateBuffer.getVariables();
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplatePosition variable = variables[i];
                if (!variable.isResolved()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    int j = 0;
                    while (j != offsets.length) {
                        group.createPosition(document, offsets[j] + start, length);
                        ++j;
                    }
                    env.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                env.forceInstall();
                LinkedUIControl editor = new LinkedUIControl(env, viewer);
                editor.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, true);
                editor.enter();
                this.fSelectedRegion = editor.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (CoreException e) {
            this.handleException(viewer.getTextWidget().getShell(), e);
            this.fSelectedRegion = this.fRegion;
        }
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplatePosition[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            this.fContext.setReadOnly(true);
            TemplateBuffer templateBuffer = this.fContext.evaluate(this.fTemplate);
            if (templateBuffer == null) {
                return null;
            }
            return templateBuffer.getString();
        }
        catch (CoreException e) {
            this.handleException(JavaPlugin.getActiveWorkbenchShell(), e);
            return null;
        }
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = String.valueOf(this.fTemplate.getName()) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
        }
        return this.fDisplayString;
    }

    public void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    private void handleException(Shell shell, CoreException e) {
        ExceptionHandler.handle(e, shell, TemplateMessages.getString("TemplateEvaluator.error.title"), null);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new TemplateInformationControlCreator();
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public CharSequence getCompletionText() {
        return null;
    }

    public int getCompletionOffset() {
        return this.fRegion.getOffset();
    }
}

