/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.link;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.internal.ui.text.link.LinkedPosition;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Position;

class TabStopIterator {
    private static final Comparator fComparator = new SequenceComparator();
    private final ArrayList fList;
    private int fSize;
    private int fIndex;
    private boolean fIsCycling = false;

    public TabStopIterator(List positionSequence) {
        Assert.isNotNull((Object)positionSequence);
        this.fList = new ArrayList(positionSequence);
        Collections.sort(this.fList, fComparator);
        this.fSize = this.fList.size();
        this.fIndex = -1;
        Assert.isTrue((this.fSize > 0 ? 1 : 0) != 0);
    }

    public boolean hasNext(LinkedPosition current) {
        return this.getNextIndex(current) != this.fSize;
    }

    private int getNextIndex(LinkedPosition current) {
        if (current != null && this.fList.get(this.fIndex) != current) {
            return this.findNext(current);
        }
        if (this.fIsCycling && this.fIndex == this.fSize - 1) {
            return 0;
        }
        return this.fIndex + 1;
    }

    private int findNext(LinkedPosition current) {
        Assert.isNotNull((Object)((Object)current));
        int index = this.fList.indexOf((Object)current);
        if (index != -1) {
            if (this.fIsCycling && index == this.fSize - 1) {
                return 0;
            }
            return index + 1;
        }
        LinkedPosition found = null;
        Iterator it = this.fList.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            if (p.offset <= current.offset || found != null && found.offset <= p.offset) continue;
            found = p;
        }
        if (found != null) {
            return this.fList.indexOf((Object)found);
        }
        if (this.fIsCycling) {
            return 0;
        }
        return this.fSize;
    }

    public boolean hasPrevious(LinkedPosition current) {
        return this.getPreviousIndex(current) != -1;
    }

    private int getPreviousIndex(LinkedPosition current) {
        if (current != null && this.fList.get(this.fIndex) != current) {
            return this.findPrevious(current);
        }
        if (this.fIsCycling && this.fIndex == 0) {
            return this.fSize - 1;
        }
        return this.fIndex - 1;
    }

    private int findPrevious(LinkedPosition current) {
        Assert.isNotNull((Object)((Object)current));
        int index = this.fList.indexOf((Object)current);
        if (index != -1) {
            if (this.fIsCycling && index == 0) {
                return this.fSize - 1;
            }
            return index - 1;
        }
        LinkedPosition found = null;
        Iterator it = this.fList.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            if (p.offset >= current.offset || found != null && found.offset >= p.offset) continue;
            found = p;
        }
        if (found != null) {
            return this.fList.indexOf((Object)found);
        }
        if (this.fIsCycling) {
            return this.fSize - 1;
        }
        return -1;
    }

    public LinkedPosition next(LinkedPosition current) {
        if (!this.hasNext(current)) {
            throw new NoSuchElementException();
        }
        this.fIndex = this.getNextIndex(current);
        return (LinkedPosition)((Object)this.fList.get(this.fIndex));
    }

    public LinkedPosition previous(LinkedPosition current) {
        if (!this.hasPrevious(current)) {
            throw new NoSuchElementException();
        }
        this.fIndex = this.getPreviousIndex(current);
        return (LinkedPosition)((Object)this.fList.get(this.fIndex));
    }

    public void setCycling(boolean mode) {
        this.fIsCycling = mode;
    }

    public void addPosition(Position position) {
        this.fList.add(this.fSize++, position);
    }

    public void removePosition(Position position) {
        if (this.fList.remove(position)) {
            --this.fSize;
        }
    }

    public boolean isCycling() {
        return this.fIsCycling;
    }

    private static class SequenceComparator
    implements Comparator {
        SequenceComparator() {
        }

        public int compare(Object o1, Object o2) {
            LinkedPosition p1 = (LinkedPosition)((Object)o1);
            LinkedPosition p2 = (LinkedPosition)((Object)o2);
            int i = p1.getSequenceNumber() - p2.getSequenceNumber();
            if (i != 0) {
                return i;
            }
            return p1.getOffset() - p2.getOffset();
        }
    }
}

