/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.link;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class LinkedUIPainter
implements PaintListener {
    private ITextViewer fViewer;
    private Position fFramePosition;
    private Color fFrameColor;

    LinkedUIPainter(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    void setPosition(Position position) {
        if (position == null || !position.equals((Object)this.fFramePosition)) {
            this.fFramePosition = position;
        }
    }

    void setColor(Color color) {
        if (color == null || !color.equals((Object)this.fFrameColor)) {
            if (this.fFrameColor != null) {
                this.fFrameColor.dispose();
            }
            this.fFrameColor = color;
        }
    }

    void dispose() {
        this.setColor(null);
        this.setPosition(null);
        this.fViewer = null;
    }

    void redraw() {
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            return;
        }
        StyledText text = this.fViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.redrawRange(widgetRange.getOffset(), widgetRange.getLength(), true);
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.fFramePosition == null || this.fFrameColor == null) {
            return;
        }
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            return;
        }
        int offset = widgetRange.getOffset();
        int length = widgetRange.getLength();
        StyledText text = this.fViewer.getTextWidget();
        Point minLocation = LinkedUIPainter.getMinimumLocation(text, offset, length);
        Point maxLocation = LinkedUIPainter.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        gc.setForeground(this.fFrameColor);
        gc.drawLine(x1, y, x2, y);
    }

    private static Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private static Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    private IRegion asWidgetRange(Position position) {
        if (this.fViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)this.fViewer;
            return extension.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()));
        }
        IRegion region = this.fViewer.getVisibleRegion();
        if (LinkedUIPainter.includes(region, position)) {
            return new Region(position.getOffset() - region.getOffset(), position.getLength());
        }
        return null;
    }

    private static boolean includes(IRegion region, Position position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    public void setViewer(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }
}

