/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.link;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.link.ILinkedListener;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPosition;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIPainter;
import org.eclipse.jdt.internal.ui.text.link.ProposalPosition;
import org.eclipse.jdt.internal.ui.text.link.TabStopIterator;
import org.eclipse.jdt.internal.ui.text.link.contentassist.ContentAssistant2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class LinkedUIControl {
    public static final int CYCLE_NEVER = 0;
    public static final int CYCLE_ALWAYS = 1;
    public static final int CYCLE_WHEN_NO_PARENT = 2;
    private LinkedUITarget fCurrentTarget;
    private LinkedEnvironment fEnvironment;
    private LinkedUITarget[] fTargets;
    private TabStopIterator fIterator;
    private LinkedUICloser fCloser = new LinkedUICloser();
    private ILinkedListener fLinkedListener = new ExitListener();
    private MySelectionListener fSelectionListener = new MySelectionListener();
    private CaretListener fCaretListener = new CaretListener();
    private final Position fCaretPosition = new Position(0, 0);
    private LinkedUIPainter fPainter;
    private IExitPolicy fExitPolicy = new NullExitPolicy();
    private LinkedPosition fFramePosition;
    private LinkedPosition fPreviousPosition;
    private ContentAssistant2 fAssistant;
    private LinkedPosition fExitPosition;
    private boolean fIsActive = false;
    private IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(this.getCategory());
    private boolean fDoContextInfo = false;

    public LinkedUIControl(LinkedEnvironment environment, LinkedUITarget[] targets) {
        this.constructor(environment, targets);
    }

    public LinkedUIControl(LinkedEnvironment environment, ITextViewer viewer) {
        this.constructor(environment, new LinkedUITarget[]{new EmptyTarget(viewer)});
    }

    public LinkedUIControl(LinkedEnvironment environment, ITextViewer[] viewers) {
        LinkedUITarget[] array = new LinkedUITarget[viewers.length];
        int i = 0;
        while (i < array.length) {
            array[i] = new EmptyTarget(viewers[i]);
            ++i;
        }
        this.constructor(environment, array);
    }

    public LinkedUIControl(LinkedEnvironment environment, LinkedUITarget target) {
        this.constructor(environment, new LinkedUITarget[]{target});
    }

    private void constructor(LinkedEnvironment environment, LinkedUITarget[] targets) {
        Assert.isNotNull((Object)environment);
        Assert.isNotNull((Object)targets);
        Assert.isTrue((targets.length > 0 ? 1 : 0) != 0);
        Assert.isTrue((environment.getTabStopSequence().size() > 0 ? 1 : 0) != 0);
        this.fEnvironment = environment;
        this.fTargets = targets;
        this.fCurrentTarget = targets[0];
        this.fIterator = new TabStopIterator(this.fEnvironment.getTabStopSequence());
        this.fIterator.setCycling(!this.fEnvironment.isNested());
        this.fEnvironment.addLinkedListener(this.fLinkedListener);
        this.fPainter = new LinkedUIPainter(this.fCurrentTarget.getViewer());
        this.fPainter.setColor(this.getFrameColor());
        this.fAssistant = new ContentAssistant2();
        this.fAssistant.setDocumentPartitioning("___java_partitioning");
        this.fCaretPosition.delete();
    }

    public void enter() {
        this.fIsActive = true;
        this.connect();
        this.next();
    }

    public void setExitPolicy(IExitPolicy policy) {
        this.fExitPolicy = policy;
    }

    public void setExitPosition(LinkedUITarget target, int offset, int length, boolean isTabStop) throws BadLocationException {
        IDocument doc;
        if (this.fExitPosition != null) {
            this.fExitPosition.getDocument().removePosition((Position)this.fExitPosition);
            this.fIterator.removePosition(this.fExitPosition);
            this.fExitPosition = null;
        }
        if ((doc = target.getViewer().getDocument()) == null) {
            return;
        }
        this.fExitPosition = new LinkedPosition(doc, offset, length, isTabStop ? Integer.MAX_VALUE : -1);
        doc.addPosition((Position)this.fExitPosition);
        if (isTabStop) {
            this.fIterator.addPosition(this.fExitPosition);
        }
    }

    public void setExitPosition(ITextViewer viewer, int offset, int length, boolean isTabStop) throws BadLocationException {
        this.setExitPosition(new EditorTarget(viewer, null), offset, length, isTabStop);
    }

    public void setCyclingMode(int mode) {
        if (mode == 1 || mode == 2 && !this.fEnvironment.isNested()) {
            this.fIterator.setCycling(true);
        } else {
            this.fIterator.setCycling(false);
        }
    }

    void next() {
        if (this.fIterator.hasNext(this.fFramePosition)) {
            this.switchPosition(this.fIterator.next(this.fFramePosition), true, true);
            return;
        }
        this.leave(2);
    }

    void previous() {
        if (this.fIterator.hasPrevious(this.fFramePosition)) {
            this.switchPosition(this.fIterator.previous(this.fFramePosition), true, true);
        } else {
            this.leave(4);
        }
    }

    private void triggerContextInfo() {
        ITextOperationTarget target = this.fCurrentTarget.getViewer().getTextOperationTarget();
        if (target != null && target.canDoOperation(14)) {
            target.doOperation(14);
        }
    }

    private void triggerContentAssist() {
        if (this.fFramePosition instanceof ProposalPosition) {
            ProposalPosition pp = (ProposalPosition)this.fFramePosition;
            this.fAssistant.setCompletions(pp.getChoices());
            this.fAssistant.showPossibleCompletions();
        } else {
            this.fAssistant.setCompletions(new ICompletionProposal[0]);
            this.fAssistant.hidePossibleCompletions();
        }
    }

    private void switchPosition(LinkedPosition pos, boolean select, boolean showProposals) {
        Assert.isNotNull((Object)((Object)pos));
        if (pos.equals((Object)this.fFramePosition)) {
            return;
        }
        JavaPlugin.getActivePage().getNavigationHistory().markLocation(JavaPlugin.getActivePage().getActiveEditor());
        ITextViewerExtension extension = (ITextViewerExtension)this.fCurrentTarget.getViewer();
        IRewriteTarget target = extension.getRewriteTarget();
        if (this.fFramePosition != null) {
            target.endCompoundChange();
        }
        this.redraw();
        IDocument oldDoc = this.fFramePosition == null ? null : this.fFramePosition.getDocument();
        IDocument newDoc = pos.getDocument();
        this.switchViewer(oldDoc, newDoc);
        this.fFramePosition = pos;
        if (this.fFramePosition != null) {
            target.beginCompoundChange();
        }
        this.fPainter.setPosition(this.fFramePosition);
        if (select) {
            this.select();
        }
        if (this.fFramePosition == this.fExitPosition && !this.fIterator.isCycling()) {
            this.leave(0);
        } else {
            this.redraw();
        }
        if (showProposals) {
            this.triggerContentAssist();
        }
        if (this.fFramePosition != this.fExitPosition && this.fDoContextInfo) {
            this.triggerContextInfo();
        }
    }

    private void switchViewer(IDocument oldDoc, IDocument newDoc) {
        if (oldDoc != newDoc) {
            LinkedUITarget target = null;
            int i = 0;
            while (i < this.fTargets.length) {
                if (this.fTargets[i].getViewer().getDocument() == newDoc) {
                    target = this.fTargets[i];
                    break;
                }
                ++i;
            }
            if (target != this.fCurrentTarget) {
                this.disconnect();
                this.fCurrentTarget = target;
                target.enter();
                this.connect();
            }
        }
    }

    private void select() {
        ITextViewer viewer = this.fCurrentTarget.getViewer();
        if (!viewer.overlapsWithVisibleRegion(this.fFramePosition.offset, this.fFramePosition.length)) {
            viewer.resetVisibleRegion();
        }
        viewer.revealRange(this.fFramePosition.offset, this.fFramePosition.length);
        viewer.setSelectedRange(this.fFramePosition.offset, this.fFramePosition.length);
    }

    private void redraw() {
        if (this.fFramePosition == null) {
            return;
        }
        IRegion widgetRange = this.asWidgetRange(this.fFramePosition);
        if (widgetRange == null) {
            this.leave(1);
            return;
        }
        StyledText text = this.fCurrentTarget.fWidget;
        if (text != null && !text.isDisposed()) {
            text.redrawRange(widgetRange.getOffset(), widgetRange.getLength(), true);
        }
    }

    private void connect() {
        Assert.isNotNull((Object)this.fCurrentTarget);
        ITextViewer viewer = this.fCurrentTarget.getViewer();
        Assert.isNotNull((Object)viewer);
        this.fCurrentTarget.fWidget = viewer.getTextWidget();
        if (this.fCurrentTarget.fWidget == null) {
            this.leave(1);
        }
        if (this.fCurrentTarget.fKeyListener == null) {
            this.fCurrentTarget.fKeyListener = new LinkedUIKeyListener();
            ((ITextViewerExtension)viewer).prependVerifyKeyListener((VerifyKeyListener)this.fCurrentTarget.fKeyListener);
        } else {
            this.fCurrentTarget.fKeyListener.setEnabled(true);
        }
        ((IPostSelectionProvider)viewer).addPostSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
        this.fPainter.setViewer(viewer);
        this.fCurrentTarget.fWidget.addPaintListener((PaintListener)this.fPainter);
        this.fCurrentTarget.fWidget.showSelection();
        this.fCurrentTarget.fWidget.addVerifyListener((VerifyListener)this.fCaretListener);
        this.fCurrentTarget.fWidget.addModifyListener((ModifyListener)this.fCaretListener);
        this.fCurrentTarget.fShell = this.fCurrentTarget.fWidget.getShell();
        if (this.fCurrentTarget.fShell == null) {
            this.leave(1);
        }
        this.fCurrentTarget.fShell.addShellListener((ShellListener)this.fCloser);
        this.fAssistant.install(viewer);
    }

    private void disconnect() {
        Assert.isNotNull((Object)this.fCurrentTarget);
        ITextViewer viewer = this.fCurrentTarget.getViewer();
        Assert.isNotNull((Object)viewer);
        this.fAssistant.uninstall();
        StyledText text = this.fCurrentTarget.fWidget;
        this.fCurrentTarget.fWidget = null;
        Shell shell = this.fCurrentTarget.fShell;
        this.fCurrentTarget.fShell = null;
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener((ShellListener)this.fCloser);
        }
        if (text != null && !text.isDisposed()) {
            text.removeModifyListener((ModifyListener)this.fCaretListener);
            text.removeVerifyListener((VerifyListener)this.fCaretListener);
            text.removePaintListener((PaintListener)this.fPainter);
        }
        this.fCurrentTarget.fKeyListener.setEnabled(false);
        ((IPostSelectionProvider)viewer).removePostSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
        this.redraw();
    }

    void leave(int flags) {
        if (!this.fIsActive) {
            return;
        }
        this.fIsActive = false;
        ITextViewerExtension extension = (ITextViewerExtension)this.fCurrentTarget.getViewer();
        IRewriteTarget target = extension.getRewriteTarget();
        target.endCompoundChange();
        this.fPainter.dispose();
        this.disconnect();
        this.redraw();
        int i = 0;
        while (i < this.fTargets.length) {
            if (this.fCurrentTarget.fKeyListener != null) {
                ((ITextViewerExtension)this.fTargets[i].getViewer()).removeVerifyKeyListener((VerifyKeyListener)this.fCurrentTarget.fKeyListener);
                this.fCurrentTarget.fKeyListener = null;
            }
            ++i;
        }
        if (this.fExitPosition != null) {
            this.fExitPosition.getDocument().removePosition((Position)this.fExitPosition);
        }
        if ((flags & 2) != 0 && this.fExitPosition != null && this.fFramePosition != this.fExitPosition) {
            this.switchPosition(this.fExitPosition, true, false);
        }
        i = 0;
        while (i < this.fTargets.length) {
            IDocument doc = this.fTargets[i].getViewer().getDocument();
            if (doc != null) {
                doc.removePositionUpdater(this.fPositionUpdater);
                boolean uninstallCat = false;
                String[] cats = doc.getPositionCategories();
                int j = 0;
                while (j < cats.length) {
                    if (this.getCategory().equals(cats[j])) {
                        uninstallCat = true;
                        break;
                    }
                    ++j;
                }
                if (uninstallCat) {
                    try {
                        doc.removePositionCategory(this.getCategory());
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
            }
            ++i;
        }
        this.fEnvironment.exit(flags);
    }

    private IRegion asWidgetRange(Position position) {
        ITextViewer viewer = this.fCurrentTarget.getViewer();
        if (viewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
            return extension.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()));
        }
        IRegion region = viewer.getVisibleRegion();
        if (LinkedUIControl.includes(region, position)) {
            return new Region(position.getOffset() - region.getOffset(), position.getLength());
        }
        return null;
    }

    private static boolean includes(IRegion region, Position position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    private Color getFrameColor() {
        StyledText text = this.fCurrentTarget.getViewer().getTextWidget();
        if (text != null) {
            Display display = text.getDisplay();
            return this.createColor(JavaPlugin.getDefault().getPreferenceStore(), "linkedPositionColor", display);
        }
        return null;
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store != null && store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return new Color((Device)display, new RGB(100, 255, 100));
    }

    public IRegion getSelectedRegion() {
        if (this.fFramePosition == null) {
            if (this.fExitPosition != null) {
                return new Region(this.fExitPosition.getOffset(), this.fExitPosition.getLength());
            }
            return null;
        }
        return new Region(this.fFramePosition.getOffset(), this.fFramePosition.getLength());
    }

    private void rememberSelection(VerifyEvent event) {
        if (event.getSource() != this.fCurrentTarget.fWidget) {
            return;
        }
        Point selection = this.fCurrentTarget.getViewer().getSelectedRange();
        this.fCaretPosition.offset = selection.x + selection.y;
        this.fCaretPosition.length = 0;
        this.fCaretPosition.isDeleted = false;
        try {
            IDocument document = this.fCurrentTarget.getViewer().getDocument();
            boolean installCat = true;
            String[] cats = document.getPositionCategories();
            int i = 0;
            while (i < cats.length) {
                if (this.getCategory().equals(cats[i])) {
                    installCat = false;
                }
                ++i;
            }
            if (installCat) {
                document.addPositionCategory(this.getCategory());
                document.addPositionUpdater(this.fPositionUpdater);
            }
            if (document.getPositions(this.getCategory()).length != 0) {
                document.removePosition(this.getCategory(), this.fCaretPosition);
            }
            document.addPosition(this.getCategory(), this.fCaretPosition);
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            Assert.isTrue((boolean)false);
        }
    }

    private void updateSelection(ModifyEvent event) {
        if (!this.fIsActive || event.getSource() != this.fCurrentTarget.fWidget) {
            return;
        }
        if (!this.fCaretPosition.isDeleted()) {
            this.fCurrentTarget.getViewer().setSelectedRange(this.fCaretPosition.getOffset(), 0);
        }
        this.fCaretPosition.isDeleted = true;
    }

    private String getCategory() {
        return this.toString();
    }

    public void setDoContextInfo(boolean doContextInfo) {
        this.fDoContextInfo = doContextInfo;
    }

    static /* synthetic */ boolean access$8(LinkedUIControl linkedUIControl) {
        return linkedUIControl.fIsActive;
    }

    private final class CaretListener
    implements ModifyListener,
    VerifyListener {
        CaretListener() {
        }

        public void modifyText(ModifyEvent e) {
            LinkedUIControl.this.updateSelection(e);
        }

        public void verifyText(VerifyEvent e) {
            LinkedUIControl.this.rememberSelection(e);
        }
    }

    public static abstract class LinkedUITarget {
        StyledText fWidget;
        Shell fShell;
        LinkedUIKeyListener fKeyListener;

        abstract ITextViewer getViewer();

        abstract void enter();
    }

    private static final class EmptyTarget
    extends LinkedUITarget {
        private ITextViewer fTextViewer;

        public EmptyTarget(ITextViewer viewer) {
            Assert.isNotNull((Object)viewer);
            this.fTextViewer = viewer;
        }

        public ITextViewer getViewer() {
            return this.fTextViewer;
        }

        public void enter() {
        }
    }

    public static class EditorTarget
    extends LinkedUITarget {
        protected final ITextViewer fTextViewer;
        protected final ITextEditor fTextEditor;

        public EditorTarget(ITextViewer viewer, ITextEditor editor) {
            Assert.isNotNull((Object)viewer);
            this.fTextViewer = viewer;
            this.fTextEditor = editor;
        }

        public ITextViewer getViewer() {
            return this.fTextViewer;
        }

        public void enter() {
            if (this.fTextEditor != null) {
                return;
            }
            IWorkbenchPage page = this.fTextEditor.getEditorSite().getPage();
            if (page != null) {
                page.bringToTop((IWorkbenchPart)this.fTextEditor);
            }
            this.fTextEditor.setFocus();
        }
    }

    private final class ExitListener
    implements ILinkedListener {
        ExitListener() {
        }

        public void left(LinkedEnvironment environment, int flags) {
            LinkedUIControl.this.leave(1 | flags);
        }

        public void suspend(LinkedEnvironment environment) {
            LinkedUIControl.this.disconnect();
            LinkedUIControl.this.redraw();
        }

        public void resume(LinkedEnvironment environment, int flags) {
            if ((flags & 1) != 0) {
                LinkedUIControl.this.leave(flags);
            } else {
                LinkedUIControl.this.connect();
                if ((flags & 4) != 0) {
                    LinkedUIControl.this.select();
                }
                LinkedUIControl.this.redraw();
            }
        }
    }

    public static class ExitFlags {
        public int flags;
        public boolean doit;

        public ExitFlags(int flags, boolean doit) {
            this.flags = flags;
            this.doit = doit;
        }
    }

    public interface IExitPolicy {
        public ExitFlags doExit(LinkedEnvironment var1, VerifyEvent var2, int var3, int var4);
    }

    private static class NullExitPolicy
    implements IExitPolicy {
        NullExitPolicy() {
        }

        public ExitFlags doExit(LinkedEnvironment environment, VerifyEvent event, int offset, int length) {
            return null;
        }
    }

    private class LinkedUICloser
    implements ShellListener {
        LinkedUICloser() {
        }

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
            LinkedUIControl.this.leave(1);
        }

        public void shellDeactivated(ShellEvent e) {
            Display display;
            StyledText text;
            if (LinkedUIControl.this.fAssistant == null || LinkedUIControl.this.fCurrentTarget == null || (text = ((LinkedUIControl)LinkedUIControl.this).fCurrentTarget.fWidget) == null || text.isDisposed() || (display = text.getDisplay()) == null || display.isDisposed()) {
                LinkedUIControl.this.leave(1);
            } else {
                display.asyncExec(new Runnable(this){
                    final /* synthetic */ LinkedUICloser this$1;
                    {
                        this.this$1 = linkedUICloser;
                    }

                    public void run() {
                        if (LinkedUIControl.access$8(LinkedUICloser.access$0(this.this$1)) && (LinkedUIControl.access$6(LinkedUICloser.access$0(this.this$1)) == null || !LinkedUIControl.access$6(LinkedUICloser.access$0(this.this$1)).hasFocus())) {
                            LinkedUICloser.access$0(this.this$1).leave(1);
                        }
                    }
                });
            }
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
            LinkedUIControl.this.leave(1);
        }

        static /* synthetic */ LinkedUIControl access$0(LinkedUICloser linkedUICloser) {
            return linkedUICloser.LinkedUIControl.this;
        }
    }

    private class LinkedUIKeyListener
    implements VerifyKeyListener {
        private boolean fIsEnabled = true;

        LinkedUIKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || !this.fIsEnabled) {
                return;
            }
            Point selection = LinkedUIControl.this.fCurrentTarget.getViewer().getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            ExitFlags exitFlags = LinkedUIControl.this.fExitPolicy.doExit(LinkedUIControl.this.fEnvironment, event, offset, length);
            if (exitFlags != null) {
                LinkedUIControl.this.leave(exitFlags.flags);
                event.doit = exitFlags.doit;
                return;
            }
            switch (event.character) {
                case '\t': {
                    if (!(LinkedUIControl.this.fExitPosition != null && LinkedUIControl.this.fExitPosition.includes(offset) || LinkedUIControl.this.fEnvironment.anyPositionContains(offset))) {
                        LinkedUIControl.this.leave(1);
                        break;
                    }
                    if (event.stateMask == 131072) {
                        LinkedUIControl.this.previous();
                    } else {
                        LinkedUIControl.this.next();
                    }
                    event.doit = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (LinkedUIControl.this.fAssistant != null && LinkedUIControl.this.fAssistant.wasProposalChosen()) {
                        LinkedUIControl.this.next();
                        event.doit = false;
                        break;
                    }
                    if (!(LinkedUIControl.this.fExitPosition != null && LinkedUIControl.this.fExitPosition.includes(offset) || LinkedUIControl.this.fEnvironment.anyPositionContains(offset))) {
                        LinkedUIControl.this.leave(1);
                        break;
                    }
                    LinkedUIControl.this.leave(3);
                    event.doit = false;
                    break;
                }
                case '\u001b': {
                    LinkedUIControl.this.leave(1);
                    event.doit = false;
                    break;
                }
                default: {
                    if (event.character == '\u0000' || this.controlUndoBehavior(offset, length)) break;
                    LinkedUIControl.this.leave(1);
                }
            }
        }

        private boolean controlUndoBehavior(int offset, int length) {
            LinkedPosition position = LinkedUIControl.this.fEnvironment.findPosition(new LinkedPosition(LinkedUIControl.this.fCurrentTarget.getViewer().getDocument(), offset, length, -1));
            if (position != null) {
                ITextViewerExtension extension = (ITextViewerExtension)LinkedUIControl.this.fCurrentTarget.getViewer();
                IRewriteTarget target = extension.getRewriteTarget();
                if (LinkedUIControl.this.fPreviousPosition != null && !LinkedUIControl.this.fPreviousPosition.equals((Object)position)) {
                    target.endCompoundChange();
                }
                target.beginCompoundChange();
            }
            LinkedUIControl.this.fPreviousPosition = position;
            return LinkedUIControl.this.fPreviousPosition != null;
        }

        public void setEnabled(boolean enabled) {
            this.fIsEnabled = enabled;
        }
    }

    private class MySelectionListener
    implements ISelectionChangedListener {
        MySelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof ITextSelection) {
                IDocument doc;
                ITextSelection textsel = (ITextSelection)selection;
                if (event.getSelectionProvider() instanceof ITextViewer && (doc = ((ITextViewer)event.getSelectionProvider()).getDocument()) != null) {
                    int offset = textsel.getOffset();
                    int length = textsel.getLength();
                    if (offset >= 0 && length >= 0) {
                        LinkedPosition find = new LinkedPosition(doc, offset, length, -1);
                        LinkedPosition pos = LinkedUIControl.this.fEnvironment.findPosition(find);
                        if (pos != null) {
                            LinkedUIControl.this.switchPosition(pos, false, false);
                        }
                    }
                }
            }
        }
    }
}

