/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPosition;
import org.eclipse.jdt.internal.ui.text.link.ProposalPosition;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LinkedPositionGroup {
    public static final int NO_STOP = -1;
    private final List fPositions = new LinkedList();
    private boolean fIsSealed = false;
    private LinkedPosition fLastPosition;
    private int fLastPositionOffset;
    private boolean fHasCustomIteration = false;

    public void createPosition(IDocument document, int offset, int length) throws BadLocationException {
        this.createPosition(document, offset, length, -1);
    }

    public void createPosition(IDocument document, int offset, int length, int sequence) throws BadLocationException {
        this.addPosition(new LinkedPosition(document, offset, length, sequence));
    }

    public void createPosition(IDocument doc, IRegion region) throws BadLocationException {
        this.createPosition(doc, region, -1);
    }

    public void createPosition(IDocument doc, IRegion region, int sequence) throws BadLocationException {
        this.createPosition(doc, region.getOffset(), region.getLength(), sequence);
    }

    public void createPosition(IDocument doc, IRegion region, ICompletionProposal[] proposals) throws BadLocationException {
        this.createPosition(doc, region, -1, proposals);
    }

    public void createPosition(IDocument doc, int offset, int length, int sequence, ICompletionProposal[] proposals) throws BadLocationException {
        this.addPosition(new ProposalPosition(doc, offset, length, sequence, proposals));
    }

    public void createPosition(IDocument doc, int offset, int length, ICompletionProposal[] proposals) throws BadLocationException {
        this.createPosition(doc, offset, length, -1, proposals);
    }

    public void createPosition(IDocument doc, IRegion region, int sequence, ICompletionProposal[] proposals) throws BadLocationException {
        this.createPosition(doc, region.getOffset(), region.getLength(), sequence, proposals);
    }

    public void createPosition(IDocument doc, IRegion region, int sequence, IContentAssistProcessor processor) throws BadLocationException {
        throw new UnsupportedOperationException();
    }

    private void addPosition(LinkedPosition position) throws BadLocationException {
        Assert.isNotNull((Object)((Object)position));
        if (this.fIsSealed) {
            throw new IllegalStateException("cannot add positions after the group is added to an environment");
        }
        if (!this.fPositions.contains((Object)position)) {
            this.enforceDisjoint(position);
            this.enforceEqualContent(position);
            this.fPositions.add(position);
            this.fHasCustomIteration |= position.getSequenceNumber() != -1;
        } else {
            return;
        }
    }

    private void enforceEqualContent(LinkedPosition position) throws BadLocationException {
        String positionContent;
        String groupContent;
        if (this.fPositions.size() > 0 && !(groupContent = ((LinkedPosition)((Object)this.fPositions.get(0))).getContent()).equals(positionContent = position.getContent())) {
            throw new BadLocationException();
        }
    }

    private void enforceDisjoint(LinkedPosition position) throws BadLocationException {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            if (!p.overlapsWith(position)) continue;
            throw new BadLocationException();
        }
    }

    void enforceDisjoint(LinkedPositionGroup group) throws BadLocationException {
        Assert.isNotNull((Object)group);
        Iterator it = group.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            this.enforceDisjoint(p);
        }
    }

    boolean isLegalEvent(DocumentEvent event) {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition pos = (LinkedPosition)((Object)it.next());
            if (!pos.includes(event)) continue;
            this.fLastPosition = pos;
            this.fLastPositionOffset = pos.getOffset();
            return true;
        }
        this.fLastPosition = null;
        this.fLastPositionOffset = -1;
        return false;
    }

    Map handleEvent(DocumentEvent event) {
        if (this.fLastPosition != null) {
            HashMap<IDocument, ArrayList<Object>> map = new HashMap<IDocument, ArrayList<Object>>();
            int relOffset = event.getOffset() - this.fLastPositionOffset;
            int length = event.getLength();
            String text = event.getText();
            Iterator<Object> it2 = this.fPositions.iterator();
            while (it2.hasNext()) {
                LinkedPosition p = (LinkedPosition)((Object)it2.next());
                if (p == this.fLastPosition) continue;
                ArrayList<ReplaceEdit> edits = (ArrayList<ReplaceEdit>)map.get(p.getDocument());
                if (edits == null) {
                    edits = new ArrayList<ReplaceEdit>();
                    map.put(p.getDocument(), edits);
                }
                edits.add(new ReplaceEdit(p.getOffset() + relOffset, length, text));
            }
            it2 = map.keySet().iterator();
            while (it2.hasNext()) {
                IDocument d = (IDocument)it2.next();
                MultiTextEdit edit = new MultiTextEdit(0, d.getLength());
                edit.addChildren(((List)map.get(d)).toArray(new TextEdit[0]));
                map.put(d, (ArrayList<Object>)edit);
            }
            return map;
        }
        return null;
    }

    void seal() throws BadLocationException {
        Assert.isTrue((!this.fIsSealed ? 1 : 0) != 0);
        this.fIsSealed = true;
        if (!this.fHasCustomIteration && this.fPositions.size() > 0) {
            ((LinkedPosition)((Object)this.fPositions.get(0))).setSequenceNumber(0);
        }
    }

    IDocument[] getDocuments() {
        IDocument[] docs = new IDocument[this.fPositions.size()];
        int i = 0;
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition pos = (LinkedPosition)((Object)it.next());
            docs[i] = pos.getDocument();
            ++i;
        }
        return docs;
    }

    void register(LinkedEnvironment environment) throws BadLocationException {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition pos = (LinkedPosition)((Object)it.next());
            environment.register(pos);
        }
    }

    LinkedPosition adopt(LinkedPositionGroup group) throws BadLocationException {
        LinkedPosition found = null;
        Iterator it = group.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition pos = (LinkedPosition)((Object)it.next());
            LinkedPosition localFound = null;
            Iterator it2 = this.fPositions.iterator();
            while (it2.hasNext()) {
                LinkedPosition myPos = (LinkedPosition)((Object)it2.next());
                if (!myPos.includes(pos)) continue;
                if (found == null) {
                    found = myPos;
                } else if (found != myPos) {
                    throw new BadLocationException();
                }
                if (localFound != null) continue;
                localFound = myPos;
            }
            if (localFound == found) continue;
            throw new BadLocationException();
        }
        return found;
    }

    LinkedPosition getPosition(LinkedPosition toFind) {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            if (!p.includes(toFind)) continue;
            return p;
        }
        return null;
    }

    boolean contains(int offset) {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition pos = (LinkedPosition)((Object)it.next());
            if (!pos.includes(offset)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmtpy() {
        return this.fPositions.size() == 0;
    }

    LinkedPosition[] getPositions() {
        return this.fPositions.toArray(new LinkedPosition[0]);
    }

    boolean contains(LinkedPosition position) {
        Iterator it = this.fPositions.iterator();
        while (it.hasNext()) {
            LinkedPosition p = (LinkedPosition)((Object)it.next());
            if (!position.equals((Object)p)) continue;
            return true;
        }
        return false;
    }
}

