/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.link;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.internal.ui.text.link.ILinkedListener;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;

class LinkedManager {
    private static Map fManagers = new HashMap();
    private Stack fEnvironments = new Stack();
    private Listener fListener = new Listener();

    LinkedManager() {
    }

    public static boolean hasManager(IDocument document) {
        return fManagers.get(document) != null;
    }

    public static boolean hasManager(IDocument[] documents) {
        int i = 0;
        while (i < documents.length) {
            if (LinkedManager.hasManager(documents[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LinkedManager getLinkedManager(IDocument[] documents, boolean force) {
        if (documents == null || documents.length == 0) {
            return null;
        }
        HashSet<LinkedManager> mgrs = new HashSet<LinkedManager>();
        LinkedManager mgr = null;
        int i = 0;
        while (i < documents.length) {
            mgr = (LinkedManager)fManagers.get(documents[i]);
            if (mgr != null) {
                mgrs.add(mgr);
            }
            ++i;
        }
        if (mgrs.size() > 1) {
            if (force) {
                Iterator it = mgrs.iterator();
                while (it.hasNext()) {
                    LinkedManager m = (LinkedManager)it.next();
                    m.closeAllEnvironments();
                }
            } else {
                return null;
            }
        }
        if (mgrs.size() == 0) {
            mgr = new LinkedManager();
        }
        i = 0;
        while (i < documents.length) {
            fManagers.put(documents[i], mgr);
            ++i;
        }
        return mgr;
    }

    public static void cancelManager(IDocument document) {
        LinkedManager mgr = (LinkedManager)fManagers.get(document);
        if (mgr != null) {
            mgr.closeAllEnvironments();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void left(LinkedEnvironment environment, int flags) {
        if (this.fEnvironments.contains(environment)) ** GOTO lbl5
        return;
        while ((env = (LinkedEnvironment)this.fEnvironments.pop()) != environment) {
            env.exit(0);
lbl5:
            // 2 sources

            if (!this.fEnvironments.isEmpty()) continue;
        }
        if (this.fEnvironments.isEmpty()) {
            this.removeManager();
        }
    }

    private void closeAllEnvironments() {
        while (!this.fEnvironments.isEmpty()) {
            LinkedEnvironment env = (LinkedEnvironment)this.fEnvironments.pop();
            env.exit(0);
        }
        this.removeManager();
    }

    private void removeManager() {
        Iterator it = fManagers.keySet().iterator();
        while (it.hasNext()) {
            IDocument doc = (IDocument)it.next();
            if (fManagers.get(doc) != this) continue;
            it.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nestEnvironment(LinkedEnvironment environment, boolean force) {
        block8: {
            block7: {
                Assert.isNotNull((Object)environment);
                try {
                    while (true) {
                        if (this.fEnvironments.isEmpty()) {
                            environment.addLinkedListener(this.fListener);
                            this.fEnvironments.push(environment);
                            Object var4_4 = null;
                            break;
                        }
                        LinkedEnvironment top = (LinkedEnvironment)this.fEnvironments.peek();
                        if (environment.canNestInto(top)) {
                            environment.addLinkedListener(this.fListener);
                            this.fEnvironments.push(environment);
                            break block7;
                        }
                        if (!force) {
                            break block8;
                        }
                        this.fEnvironments.pop();
                        top.exit(0);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    Assert.isTrue((this.fEnvironments.size() > 0 ? 1 : 0) != 0);
                    throw throwable;
                }
                Assert.isTrue((this.fEnvironments.size() > 0 ? 1 : 0) != 0);
                return true;
            }
            Object var4_5 = null;
            Assert.isTrue((this.fEnvironments.size() > 0 ? 1 : 0) != 0);
            return true;
        }
        Object var4_6 = null;
        Assert.isTrue((this.fEnvironments.size() > 0 ? 1 : 0) != 0);
        return false;
    }

    public LinkedEnvironment getTopEnvironment() {
        if (this.fEnvironments.isEmpty()) {
            return null;
        }
        return (LinkedEnvironment)this.fEnvironments.peek();
    }

    private class Listener
    implements ILinkedListener {
        Listener() {
        }

        public void left(LinkedEnvironment environment, int flags) {
            LinkedManager.this.left(environment, flags);
        }

        public void suspend(LinkedEnvironment environment) {
        }

        public void resume(LinkedEnvironment environment, int flags) {
        }
    }
}

