/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;

    public SourceViewerInformationControl(Shell parent, int shellStyle, int style) {
        this(parent, shellStyle, style, null);
    }

    public SourceViewerInformationControl(Shell parent, int shellStyle, int style, String statusFieldText) {
        int border;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(display.getSystemColor(29));
        }
        this.fViewer = new JavaSourceViewer((Composite)composite, null, null, false, style);
        this.fViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools(), null));
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(parent.getDisplay().getSystemColor(28));
        this.fText.setBackground(parent.getDisplay().getSystemColor(29));
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gd2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
    }

    public SourceViewerInformationControl(Shell parent, int style) {
        this(parent, 8, style);
    }

    public SourceViewerInformationControl(Shell parent, int style, String statusFieldText) {
        this(parent, 8, style, statusFieldText);
    }

    public SourceViewerInformationControl(Shell parent) {
        this(parent, 0);
    }

    public SourceViewerInformationControl(Shell parent, String statusFieldText) {
        this(parent, 0, statusFieldText);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document doc = new Document(content);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)doc);
        this.fViewer.setInput((Object)doc);
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fText = null;
        }
    }

    public void setSize(int width, int height) {
        if (this.fStatusField != null) {
            GridData gd = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point statusSize = this.fStatusField.computeSize(-1, -1, true);
            Point separatorSize = this.fSeparator.computeSize(-1, -1, true);
            gd.heightHint = height - statusSize.y - separatorSize.y;
        }
        this.fShell.setSize(width, height);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fText.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        maxWidth = maxHeight;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }
}

