/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;

public class JavaSourceHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    protected String getHoverInfo(IJavaElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IJavaElement curr = result[0];
        if ((curr instanceof IMember || curr instanceof ILocalVariable) && curr instanceof ISourceReference) {
            try {
                String source = ((ISourceReference)curr).getSource();
                if (source == null) {
                    return null;
                }
                source = this.removeLeadingComments(source);
                String delim = null;
                try {
                    delim = StubUtility.getLineDelimiterUsed(result[0]);
                }
                catch (JavaModelException javaModelException) {
                    delim = System.getProperty("line.separator", "\n");
                }
                String[] sourceLines = Strings.convertIntoLines(source);
                String firstLine = sourceLines[0];
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = "";
                }
                Strings.trimIndentation(sourceLines, CodeFormatterUtil.getTabWidth());
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = firstLine;
                }
                source = Strings.concatenate(sourceLines, delim);
                return source;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeLeadingComments(String source) {
        block11: {
            reader = new JavaCodeReader();
            document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    c = reader.read();
                    while (true) {
                        if (c == -1 || c != 13 && c != 10) {
                            i = reader.getOffset();
                            reader.close();
                        }
                        c = reader.read();
                    }
                }
                catch (IOException v0) {
                    i = 0;
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (reader == null) throw var7_6;
                    reader.close();
                    throw var7_6;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 96->107)] { 
lbl29:
            // 1 sources

            if (reader != null) {
                reader.close();
            }
            break block11;
lbl32:
            // 1 sources

            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
        }
        if (i >= 0) return source.substring(i);
        return source;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                String affordanceString = null;
                if (JavaPlugin.getDefault().getPreferenceStore().getBoolean(PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE)) {
                    affordanceString = JavaHoverMessages.getString("JavaTextHover.makeStickyHint");
                }
                return new SourceViewerInformationControl(parent, affordanceString);
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

