/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.AnnotationHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!PreferenceConstants.ID_BESTMATCH_HOVER.equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
        Collections.sort(this.fTextHoverSpecifications, new JavaEditorTextHoverDescriptorComparator());
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        Iterator iterator = new ArrayList(this.fTextHoverSpecifications).iterator();
        while (iterator.hasNext()) {
            JavaEditorTextHoverDescriptor spec = (JavaEditorTextHoverDescriptor)iterator.next();
            IJavaEditorTextHover hover = spec.createTextHover();
            if (hover == null) continue;
            hover.setEditor(this.getEditor());
            this.addTextHover(hover);
            this.fTextHoverSpecifications.remove(spec);
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            ITextHover hover = (ITextHover)iterator.next();
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getInformationControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }

    private static class JavaEditorTextHoverDescriptorComparator
    implements Comparator {
        JavaEditorTextHoverDescriptorComparator() {
        }

        public int compare(Object object0, Object object1) {
            JavaEditorTextHoverDescriptor element0 = (JavaEditorTextHoverDescriptor)object0;
            JavaEditorTextHoverDescriptor element1 = (JavaEditorTextHoverDescriptor)object1;
            String id0 = element0.getId();
            String id1 = element1.getId();
            if (id0 != null && id0.equals(id1)) {
                return 0;
            }
            if (id0 != null && AnnotationHover.isJavaProblemHover(id0)) {
                return -1;
            }
            if (id1 != null && AnnotationHover.isJavaProblemHover(id1)) {
                return 1;
            }
            if (element0.dependsOn(element1)) {
                return -1;
            }
            if (element1.dependsOn(element0)) {
                return 1;
            }
            return 0;
        }
    }
}

