/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class AnnotationHover
extends AbstractJavaEditorTextHover {
    private IPreferenceStore fStore = JavaPlugin.getDefault().getPreferenceStore();
    private IAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private AnnotationPreferenceLookup fPreferenceLookup = new AnnotationPreferenceLookup();

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICompilationUnitDocumentProvider provider;
        IAnnotationModel model;
        if (this.getEditor() == null) {
            return null;
        }
        IAnnotationAccessExtension annotationAccessExtension = null;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            annotationAccessExtension = (IAnnotationAccessExtension)this.fAnnotationAccess;
        }
        if ((model = (provider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider()).getAnnotationModel(this.getEditor().getEditorInput())) != null) {
            JavaAnnotationIterator e = new JavaAnnotationIterator(model, true);
            int layer = -1;
            String message = null;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                AnnotationPreference preference = this.getAnnotationPreference(a);
                if (preference == null || !this.fStore.getBoolean(preference.getTextPreferenceKey()) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
                Position p = model.getPosition(a);
                int l = 0;
                if (this.fAnnotationAccess != null) {
                    l = annotationAccessExtension.getLayer(a);
                }
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                message = msg;
                layer = l;
            }
            if (layer > -1) {
                return this.formatMessage(message);
            }
        }
        return null;
    }

    public void setEditor(IEditorPart editor) {
        if (editor instanceof CompilationUnitEditor) {
            super.setEditor(editor);
        } else {
            super.setEditor(null);
        }
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return this.fPreferenceLookup.getAnnotationPreference(annotation);
    }

    static boolean isJavaProblemHover(String id) {
        return PreferenceConstants.ID_PROBLEM_HOVER.equals(id);
    }
}

