/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionGroup;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIControl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class ParameterGuessingProposal
extends JavaCompletionProposal {
    private final char[] fName;
    private final char[][] fParameterNames;
    private final char[][] fParamaterTypePackageNames;
    private final char[][] fParameterTypeNames;
    private final int fCodeAssistOffset;
    private final ICompilationUnit fCompilationUnit;
    private final ITextViewer fViewer;
    private IRegion fSelectedRegion;
    private ICompletionProposal[][] fChoices;

    public ParameterGuessingProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, ITextViewer viewer, int relevance, char[] name, char[][] paramaterTypePackageNames, char[][] parameterTypeNames, char[][] parameterNames, int codeAssistOffset, ICompilationUnit compilationUnit) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fName = name;
        this.fParamaterTypePackageNames = paramaterTypePackageNames;
        this.fParameterTypeNames = parameterTypeNames;
        this.fParameterNames = parameterNames;
        this.fViewer = viewer;
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
    }

    private boolean appendArguments(IDocument document, int offset) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_insert_completion") ^ this.fToggleEating) {
            return true;
        }
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index == line.length()) {
                return true;
            }
            return line.charAt(index) != '(';
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            String replacementString;
            int[] positionLengths;
            int[] positionOffsets;
            int parameterCount = this.fParameterNames.length;
            int baseOffset = this.getReplacementOffset();
            if (this.appendArguments(document, offset)) {
                parameterCount = this.fParameterNames.length;
                positionOffsets = new int[parameterCount];
                positionLengths = new int[parameterCount];
                replacementString = this.computeGuessingCompletion(baseOffset, positionOffsets, positionLengths);
            } else {
                parameterCount = 0;
                positionOffsets = new int[]{};
                positionLengths = new int[]{};
                replacementString = new String(this.fName);
            }
            this.setReplacementString(replacementString);
            super.apply(document, trigger, offset);
            if (parameterCount > 0) {
                LinkedEnvironment environment = new LinkedEnvironment();
                int i = 0;
                while (i != parameterCount) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = baseOffset + positionOffsets[i];
                    if (this.fChoices[i].length < 2) {
                        group.createPosition(document, positionOffset, positionLengths[i]);
                    } else {
                        group.createPosition(document, positionOffset, positionLengths[i], this.fChoices[i]);
                    }
                    environment.addGroup(group);
                    ++i;
                }
                environment.forceInstall();
                LinkedUIControl editor = new LinkedUIControl(environment, this.fViewer);
                editor.setExitPosition(this.fViewer, baseOffset + replacementString.length(), 0, true);
                editor.setCyclingMode(2);
                editor.setDoContextInfo(true);
                editor.enter();
                this.fSelectedRegion = editor.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacementString.length(), 0);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    private ICompletionProposal[][] guessParameters(int offset) throws JavaModelException {
        this.fChoices = new ICompletionProposal[this.fParameterNames.length][];
        if (this.fCompilationUnit == null) {
            int i = 0;
            while (i != this.fParameterNames.length) {
                String name = new String(this.fParameterNames[i]);
                int length = name.length();
                this.fChoices[i] = new ICompletionProposal[]{new CompletionProposal(name, offset, length, length)};
                offset += length + 2;
                ++i;
            }
            return this.fChoices;
        }
        ICompilationUnit i = this.fCompilationUnit;
        synchronized (i) {
            this.fCompilationUnit.reconcile();
        }
        ParameterGuesser guesser = new ParameterGuesser(this.fCodeAssistOffset, this.fCompilationUnit);
        int i2 = this.fParameterNames.length - 1;
        while (i2 >= 0) {
            ICompletionProposal[] iCompletionProposalArray;
            String paramName = new String(this.fParameterNames[i2]);
            ICompletionProposal[] parameter = guesser.parameterProposals(new String(this.fParamaterTypePackageNames[i2]), new String(this.fParameterTypeNames[i2]), paramName, offset);
            int paramLength = paramName.length();
            if (parameter == null) {
                ICompletionProposal[] iCompletionProposalArray2 = new ICompletionProposal[1];
                iCompletionProposalArray = iCompletionProposalArray2;
                iCompletionProposalArray2[0] = new CompletionProposal(paramName, offset, paramLength, paramLength);
            } else {
                iCompletionProposalArray = parameter;
            }
            this.fChoices[i2] = iCompletionProposalArray;
            offset += paramLength + 2;
            --i2;
        }
        return this.fChoices;
    }

    private String computeGuessingCompletion(int startOffset, int[] offsets, int[] lengths) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fName);
        buffer.append('(');
        this.fChoices = this.guessParameters(startOffset + buffer.length());
        int i = 0;
        while (i < this.fChoices.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            offsets[i] = buffer.length();
            ICompletionProposal[] proposals = this.fChoices[i];
            String display = proposals.length > 0 ? proposals[0].getDisplayString() : new String(this.fParameterNames[i]);
            buffer.append(display);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    public String toString() {
        return String.valueOf(this.getDisplayString()) + super.toString();
    }
}

