/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ParameterGuesser {
    private final ICompilationUnit fCompilationUnit;
    private final int fCodeAssistOffset;
    private List fVariables;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();

    public ParameterGuesser(int codeAssistOffset, ICompilationUnit compilationUnit) {
        Assert.isTrue(codeAssistOffset >= 0);
        Assert.isNotNull(compilationUnit);
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
    }

    public int getCodeAssistOffset() {
        return this.fCodeAssistOffset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String guessParameterName(String paramPackage, String paramType, String paramName) throws JavaModelException {
        if (this.fVariables == null) {
            VariableCollector variableCollector = new VariableCollector();
            this.fVariables = variableCollector.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        List typeMatches = this.findFieldsMatchingType(this.fVariables, paramPackage, paramType);
        return ParameterGuesser.chooseBestMatch(typeMatches, paramName);
    }

    public String[] parameterMatches(String paramPackage, String paramType, String paramName) throws JavaModelException {
        if (this.fVariables == null) {
            VariableCollector variableCollector = new VariableCollector();
            this.fVariables = variableCollector.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        List typeMatches = this.findFieldsMatchingType(this.fVariables, paramPackage, paramType);
        ParameterGuesser.orderMatches(typeMatches, paramName);
        if (typeMatches == null) {
            return new String[0];
        }
        String[] ret = new String[typeMatches.size()];
        int i = 0;
        Iterator it = typeMatches.iterator();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            ret[i++] = v.name;
        }
        return ret;
    }

    public ICompletionProposal[] parameterProposals(String paramPackage, String paramType, String paramName, int offset) throws JavaModelException {
        if (this.fVariables == null) {
            VariableCollector variableCollector = new VariableCollector();
            this.fVariables = variableCollector.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        List typeMatches = this.findFieldsMatchingType(this.fVariables, paramPackage, paramType);
        ParameterGuesser.orderMatches(typeMatches, paramName);
        if (typeMatches == null) {
            return new ICompletionProposal[0];
        }
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        Iterator it = typeMatches.iterator();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            if (i == 0) {
                v.alreadyMatched = true;
                replacementLength = v.name.length();
            }
            JavaCompletionProposal proposal = new JavaCompletionProposal(v.name, offset, replacementLength, this.getImage(v.descriptor), v.name, ret.length - i);
            char[] triggers = new char[v.triggerChars.length + 1];
            System.arraycopy(v.triggerChars, 0, triggers, 0, v.triggerChars.length);
            triggers[triggers.length - 1] = 59;
            proposal.setTriggerCharacters(triggers);
            ret[i++] = proposal;
        }
        return ret;
    }

    private static String chooseBestMatch(List typeMatches, String paramName) {
        if (typeMatches == null) {
            return null;
        }
        Variable bestMatch = null;
        int bestSubstringScore = 0;
        Iterator i = typeMatches.iterator();
        while (i.hasNext()) {
            Variable variable = (Variable)i.next();
            if (variable.alreadyMatched) continue;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(variable.name, paramName).length();
            if (bestMatch == null) {
                bestMatch = variable;
                bestSubstringScore = subStringScore;
                continue;
            }
            if (variable.variableType < bestMatch.variableType) {
                bestMatch = variable;
                continue;
            }
            if (subStringScore > bestSubstringScore) {
                bestMatch = variable;
                bestSubstringScore = subStringScore;
                continue;
            }
            if (variable.positionScore > bestMatch.positionScore) {
                bestMatch = variable;
                continue;
            }
            if (!bestMatch.alreadyMatched || variable.alreadyMatched) continue;
            bestMatch = variable;
        }
        if (bestMatch == null) {
            return null;
        }
        bestMatch.alreadyMatched = true;
        return bestMatch.name;
    }

    private static void orderMatches(List typeMatches, String paramName) {
        if (typeMatches != null) {
            Collections.sort(typeMatches, new MatchComparator(paramName));
        }
    }

    private List findFieldsMatchingType(List variables, String typePackage, String typeName) throws JavaModelException {
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        ArrayList<Variable> matches = new ArrayList<Variable>();
        ListIterator iterator = variables.listIterator(variables.size());
        while (iterator.hasPrevious()) {
            Variable variable = (Variable)iterator.previous();
            if (!this.isTypeMatch(variable, typePackage, typeName)) continue;
            matches.add(variable);
        }
        if (!ParameterGuesser.isPrimitive(typeName.toCharArray())) {
            matches.add(new Variable(typePackage, typeName, "null", 1, 2, new char[0], null));
        }
        return matches.isEmpty() ? null : matches;
    }

    private boolean isTypeMatch(Variable variable, String typePackage, String typeName) throws JavaModelException {
        if ((typePackage == null || variable.typePackage == null || typePackage.length() == 0 || variable.typePackage.length() == 0) && variable.typeName.equals(typeName)) {
            return true;
        }
        if (variable.typeName.equals(typeName) && variable.typePackage.equals(typePackage)) {
            return true;
        }
        return this.isAssignable(variable, typePackage, typeName);
    }

    private boolean isAssignable(Variable variable, String typePackage, String typeName) throws JavaModelException {
        StringBuffer paramTypeName = new StringBuffer();
        if (typePackage.length() != 0) {
            paramTypeName.append(typePackage);
            paramTypeName.append('.');
        }
        paramTypeName.append(typeName);
        StringBuffer varTypeName = new StringBuffer();
        if (variable.typePackage.length() != 0) {
            varTypeName.append(variable.typePackage);
            varTypeName.append('.');
        }
        varTypeName.append(variable.typeName);
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        IType paramType = project.findType(paramTypeName.toString());
        IType varType = project.findType(varTypeName.toString());
        if (varType == null || paramType == null) {
            return false;
        }
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(varType);
        return hierarchy.contains(paramType);
    }

    static String getLongestCommonSubstring(String first, String second) {
        String shorter = first.length() <= second.length() ? first : second;
        String longer = shorter == first ? second : first;
        int minLength = shorter.length();
        StringBuffer pattern = new StringBuffer(shorter.length() + 2);
        String longestCommonSubstring = "";
        int i = 0;
        while (i < minLength) {
            int j = i + 1;
            while (j <= minLength) {
                if (j - i >= longestCommonSubstring.length()) {
                    String substring = shorter.substring(i, j);
                    pattern.setLength(0);
                    pattern.append('*');
                    pattern.append(substring);
                    pattern.append('*');
                    StringMatcher matcher = new StringMatcher(pattern.toString(), true, false);
                    if (matcher.match(longer)) {
                        longestCommonSubstring = substring;
                    }
                }
                ++j;
            }
            ++i;
        }
        return longestCommonSubstring;
    }

    private Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    private static boolean isPrimitive(char[] typeName) {
        String s = new String(typeName);
        return "boolean".equals(s) || "byte".equals(s) || "short".equals(s) || "int".equals(s) || "long".equals(s) || "float".equals(s) || "double".equals(s) || "char".equals(s);
    }

    private static final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int METHOD = 1;
        public static final int INHERITED_FIELD = 3;
        public static final int INHERITED_METHOD = 3;
        public final String typePackage;
        public final String typeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public boolean alreadyMatched;
        public char[] triggerChars;
        public ImageDescriptor descriptor;

        public Variable(String typePackage, String typeName, String name, int variableType, int positionScore, char[] triggers, ImageDescriptor descriptor) {
            this.typePackage = typePackage;
            this.typeName = typeName;
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
            this.triggerChars = triggers;
            this.descriptor = descriptor;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.typePackage.length() != 0) {
                buffer.append(this.typePackage);
                buffer.append('.');
            }
            buffer.append(this.typeName);
            buffer.append(' ');
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.variableType);
            buffer.append(')');
            return buffer.toString();
        }
    }

    private static final class VariableCollector
    extends CompletionRequestorAdapter {
        private String fEnclosingTypeName;
        private List fVariables;

        VariableCollector() {
        }

        public List collect(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            String thisPkg;
            String thisType;
            Assert.isTrue(codeAssistOffset >= 0);
            Assert.isNotNull(compilationUnit);
            this.fVariables = new ArrayList();
            String source = compilationUnit.getSource();
            if (source == null) {
                return this.fVariables;
            }
            this.fEnclosingTypeName = VariableCollector.getEnclosingTypeName(codeAssistOffset, compilationUnit);
            int completionOffset = VariableCollector.getCompletionOffset(source, codeAssistOffset);
            compilationUnit.codeComplete(completionOffset, (ICompletionRequestor)this);
            int dotPos = this.fEnclosingTypeName.lastIndexOf(46);
            if (dotPos != -1) {
                thisType = this.fEnclosingTypeName.substring(dotPos + 1);
                thisPkg = this.fEnclosingTypeName.substring(0, dotPos);
            } else {
                thisPkg = new String();
                thisType = this.fEnclosingTypeName;
            }
            this.addVariable(1, thisPkg.toCharArray(), thisType.toCharArray(), "this".toCharArray(), new char[]{'.'}, this.getFieldDescriptor(17));
            this.addVariable(1, new char[0], "boolean".toCharArray(), "true".toCharArray(), new char[0], null);
            this.addVariable(1, new char[0], "boolean".toCharArray(), "false".toCharArray(), new char[0], null);
            return this.fVariables;
        }

        private static String getEnclosingTypeName(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            IJavaElement element = compilationUnit.getElementAt(codeAssistOffset);
            if (element == null) {
                return null;
            }
            if ((element = element.getAncestor(7)) == null) {
                return null;
            }
            return element.getElementName();
        }

        private static int getCompletionOffset(String source, int start) {
            char c;
            int index = start;
            while (index > 0 && (c = source.charAt(index - 1)) != '{' && c != ';') {
                --index;
            }
            return Math.min(index + 1, source.length());
        }

        private final boolean isInherited(String declaringTypeName) {
            return !declaringTypeName.equals(this.fEnclosingTypeName);
        }

        private void addVariable(int varType, char[] typePackageName, char[] typeName, char[] name, char[] triggers, ImageDescriptor descriptor) {
            this.fVariables.add(new Variable(new String(typePackageName), new String(typeName), new String(name), varType, this.fVariables.size(), triggers, descriptor));
        }

        public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            char[] cArray;
            if (ParameterGuesser.isPrimitive(typeName)) {
                cArray = new char[]{};
            } else {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = 46;
            }
            char[] triggers = cArray;
            if (!this.isInherited(new String(declaringTypeName))) {
                this.addVariable(1, typePackageName, typeName, name, triggers, this.getFieldDescriptor(modifiers));
            } else {
                this.addVariable(3, typePackageName, typeName, name, triggers, this.getFieldDescriptor(modifiers));
            }
        }

        public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            char[] cArray;
            if (ParameterGuesser.isPrimitive(typeName)) {
                cArray = new char[]{};
            } else {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = 46;
            }
            char[] triggers = cArray;
            this.addVariable(0, typePackageName, typeName, name, triggers, JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
        }

        public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if (parameterNames.length == 0) {
                char[] cArray;
                if (ParameterGuesser.isPrimitive(returnTypeName)) {
                    cArray = new char[]{};
                } else {
                    char[] cArray2 = new char[1];
                    cArray = cArray2;
                    cArray2[0] = 46;
                }
                char[] triggers = cArray;
                this.addVariable(this.isInherited(new String(declaringTypeName)) ? 3 : 1, returnTypePackageName, returnTypeName, completionName, triggers, this.getMemberDescriptor(modifiers));
            }
        }

        protected ImageDescriptor getMemberDescriptor(int modifiers) {
            ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(false, modifiers);
            if (Flags.isDeprecated((int)modifiers)) {
                desc = this.getDeprecatedDescriptor(desc);
            }
            if (Flags.isStatic((int)modifiers)) {
                desc = this.getStaticDescriptor(desc);
            }
            return desc;
        }

        protected ImageDescriptor getFieldDescriptor(int modifiers) {
            ImageDescriptor desc = JavaElementImageProvider.getFieldImageDescriptor(false, modifiers);
            if (Flags.isDeprecated((int)modifiers)) {
                desc = this.getDeprecatedDescriptor(desc);
            }
            if (Flags.isStatic((int)modifiers)) {
                desc = this.getStaticDescriptor(desc);
            }
            return desc;
        }

        protected ImageDescriptor getDeprecatedDescriptor(ImageDescriptor descriptor) {
            Point size = new Point(16, 16);
            return new JavaElementImageDescriptor(descriptor, 32, size);
        }

        protected ImageDescriptor getStaticDescriptor(ImageDescriptor descriptor) {
            Point size = new Point(16, 16);
            return new JavaElementImageDescriptor(descriptor, 8, size);
        }
    }

    private static class MatchComparator
    implements Comparator {
        private String fParamName;

        MatchComparator(String paramName) {
            this.fParamName = paramName;
        }

        public int compare(Object o1, Object o2) {
            Variable one = (Variable)o1;
            Variable two = (Variable)o2;
            return this.score(two) - this.score(one);
        }

        private int score(Variable v) {
            int shorter;
            int variableScore = 10 - v.variableType;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(v.name, this.fParamName).length();
            if ((double)subStringScore < 0.6 * (double)(shorter = Math.min(v.name.length(), this.fParamName.length()))) {
                subStringScore = 0;
            }
            int positionScore = v.positionScore;
            int matchedScore = v.alreadyMatched ? 0 : 1;
            int score = variableScore << 21 | subStringScore << 11 | matchedScore << 10 | positionScore;
            return score;
        }
    }
}

