/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;

public class JavaFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fIndentations = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private final LinkedList fPositions = new LinkedList();

    public JavaFormattingStrategy(ISourceViewer viewer) {
        super(viewer);
    }

    public void format() {
        super.format();
        Assert.isLegal((this.fIndentations.size() > 0 ? 1 : 0) != 0);
        Assert.isLegal((this.fPartitions.size() > 0 ? 1 : 0) != 0);
        Assert.isLegal((this.fPositions.size() > 0 ? 1 : 0) != 0);
        int[] positions = (int[])this.fPositions.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        Map preferences = this.getPreferences();
        IDocument document = this.getViewer().getDocument();
        int indent = 0;
        try {
            if (CodeFormatterUtil.useOldFormatter()) {
                String formatted = CodeFormatterUtil.format(8, document.get(), partition.getOffset(), partition.getLength(), indent, positions, TextUtilities.getDefaultLineDelimiter((IDocument)document), preferences);
                String raw = document.get(partition.getOffset(), partition.getLength());
                if (formatted != null && !formatted.equals(raw)) {
                    document.replace(partition.getOffset(), partition.getLength(), formatted);
                }
            } else {
                Position toFormat = new Position(partition.offset, partition.length);
                this.stripLeadingWS(document, toFormat);
                this.stripTrailingWS(document, toFormat, (Position)partition);
                Document formattedDoc = new Document(CodeFormatterUtil.format(8, document.get(), toFormat.offset, toFormat.length, indent, positions, TextUtilities.getDefaultLineDelimiter((IDocument)document), preferences));
                int leadingEmptyLines = document.getNumberOfLines(partition.offset, toFormat.offset - partition.offset) - 1;
                int trailingEmptyLines = document.getNumberOfLines(toFormat.offset + toFormat.length, partition.offset + partition.length - (toFormat.offset + toFormat.length)) - 1;
                int from = this.getLeadingWSOffset(leadingEmptyLines, (IDocument)formattedDoc);
                int to = this.getTrailingWSOffset(trailingEmptyLines, (IDocument)formattedDoc);
                String formatted = formattedDoc.get(from, to - from);
                String raw = document.get(partition.getOffset(), partition.getLength());
                if (formatted != null && !formatted.equals(raw)) {
                    document.replace(partition.getOffset(), partition.getLength(), formatted);
                }
            }
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    private void stripLeadingWS(IDocument document, Position toFormat) throws BadLocationException {
        int offset = toFormat.getOffset();
        int length = toFormat.getLength();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(document.getChar(offset + i))) break;
            ++toFormat.offset;
            --toFormat.length;
            ++i;
        }
    }

    private void stripTrailingWS(IDocument document, Position toFormat, Position partition) throws BadLocationException {
        int offset = toFormat.getOffset();
        int length = toFormat.getLength();
        int line = document.getLineOfOffset(offset + length);
        int i = length;
        while (i > 0) {
            if (!Character.isWhitespace(document.getChar(offset + i - 1))) break;
            --toFormat.length;
            --i;
        }
        if (document.getLineOfOffset(toFormat.length + toFormat.offset) != line) {
            IRegion region = document.getLineInformation(line - 1);
            int endOfLine = region.getOffset() + region.getLength();
            partition.setLength(endOfLine - partition.offset);
        }
    }

    private int getLeadingWSOffset(int leadingEmptyLines, IDocument document) throws BadLocationException {
        int nLines = document.getNumberOfLines();
        int line = 0;
        while (line < nLines) {
            IRegion region = document.getLineInformation(line);
            if (document.get(region.getOffset(), region.getLength()).trim().length() != 0) break;
            ++line;
        }
        int wsLine = Math.max(line - leadingEmptyLines, 0);
        return document.getLineOffset(wsLine);
    }

    private int getTrailingWSOffset(int trailingEmptyLines, IDocument document) throws BadLocationException {
        int numberOfLines = document.getNumberOfLines();
        int line = numberOfLines - 1;
        while (line >= 0) {
            IRegion region = document.getLineInformation(line);
            if (document.get(region.getOffset(), region.getLength()).trim().length() != 0) break;
            --line;
        }
        int wsLine = Math.min(line + trailingEmptyLines, numberOfLines);
        IRegion region = document.getLineInformation(wsLine);
        return region.getOffset() + region.getLength();
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        FormattingContext current = (FormattingContext)context;
        this.fIndentations.addLast(current.getProperty((Object)"formatting.context.indentation"));
        this.fPartitions.addLast(current.getProperty((Object)"formatting.context.partition"));
        this.fPositions.addLast(current.getProperty((Object)"formatting.context.positions"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fIndentations.clear();
        this.fPartitions.clear();
        this.fPositions.clear();
    }
}

