/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionGroup;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIControl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class ExperimentalProposal
extends JavaCompletionProposal {
    private int[] fPositionOffsets;
    private int[] fPositionLengths;
    private ITextViewer fViewer;
    private IRegion fSelectedRegion;

    public ExperimentalProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int[] positionOffsets, int[] positionLengths, ITextViewer viewer, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fPositionOffsets = positionOffsets;
        this.fPositionLengths = positionLengths;
        this.fViewer = viewer;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int replacementOffset = this.getReplacementOffset();
        String replacementString = this.getReplacementString();
        if (this.fPositionOffsets.length > 0) {
            try {
                LinkedEnvironment env = new LinkedEnvironment();
                int i = 0;
                while (i != this.fPositionOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.createPosition(document, replacementOffset + this.fPositionOffsets[i], this.fPositionLengths[i]);
                    env.addGroup(group);
                    ++i;
                }
                env.forceInstall();
                LinkedUIControl ui = new LinkedUIControl(env, this.fViewer);
                ui.setExitPosition(this.fViewer, replacementOffset + replacementString.length(), 0, true);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                this.openErrorDialog(e);
            }
        } else {
            this.fSelectedRegion = new Region(replacementOffset + replacementString.length(), 0);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }
}

