/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.CodeGeneration;

public class UnimplementedMethodsCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;
    private IMethodBinding[] fMethodsToOverride;

    public UnimplementedMethodsCompletionProposal(ICompilationUnit cu, ASTNode typeNode, int relevance) {
        super(null, cu, null, relevance, null);
        this.setDisplayName(CorrectionMessages.getString("UnimplementedMethodsCompletionProposal.description"));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fTypeNode = typeNode;
        this.fMethodsToOverride = null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        List bodyDecls;
        ITypeBinding binding;
        AnonymousClassDeclaration decl;
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            bodyDecls = decl.bodyDeclarations();
        } else {
            decl = (TypeDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            bodyDecls = decl.bodyDeclarations();
        }
        IMethodBinding[] methods = this.evalUnimplementedMethods(binding);
        this.fMethodsToOverride = methods;
        ASTRewrite rewrite = new ASTRewrite(this.fTypeNode);
        AST ast = this.fTypeNode.getAST();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (!settings.createComments || binding.isAnonymous()) {
            settings = null;
        }
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, methods[i], rewrite, binding.getName(), settings);
            rewrite.markAsInserted((ASTNode)newMethodDecl);
            bodyDecls.add(newMethodDecl);
            ++i;
        }
        return rewrite;
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, String typeName, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String placeHolder;
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setModifiers(binding.getModifiers() & 0xFFFFFBFF);
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        String returnTypeName = this.addImport(binding.getReturnType());
        decl.setReturnType(ASTNodeFactory.newType(ast, returnTypeName));
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = this.getArgumentNames(binding);
        int i = 0;
        while (i < params.length) {
            String paramTypeName = this.addImport(params[i]);
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(ASTNodeFactory.newType(ast, paramTypeName));
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
            ++i;
        }
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = binding.getExceptionTypes();
        int i2 = 0;
        while (i2 < excTypes.length) {
            String excTypeName = this.addImport(excTypes[i2]);
            thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
            ++i2;
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String bodyStatement = "";
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType(), decl.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, String.valueOf('\n'));
        }
        if ((placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), typeName, binding.getName(), false, bodyStatement, String.valueOf('\n'))) != null) {
            ASTNode todoNode = rewrite.createPlaceholder(placeHolder, 4);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), typeName, decl, binding, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createPlaceholder(string, 8);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IJavaProject project = this.getCompilationUnit().getJavaProject();
                IMethod method = Bindings.findMethod(binding, project);
                if (method != null) {
                    return StubUtility.suggestArgumentNames(project, method.getParameterNames());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String[] names = new String[nParams];
        int i = 0;
        while (i < names.length) {
            names[i] = "arg" + i;
            ++i;
        }
        return names;
    }

    private void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, HashSet visited, ArrayList allMethods, ArrayList toImplement) {
        if (visited.add(typeBinding)) {
            IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
            int i = 0;
            while (i < typeMethods.length) {
                IMethodBinding curr = typeMethods[i];
                IMethodBinding impl = this.findMethod(curr, allMethods);
                if (impl == null || curr.getExceptionTypes().length < impl.getExceptionTypes().length && !Modifier.isFinal((int)impl.getModifiers())) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    toImplement.add(curr);
                    allMethods.add(curr);
                }
                ++i;
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            int i2 = 0;
            while (i2 < superInterfaces.length) {
                this.findUnimplementedInterfaceMethods(superInterfaces[i2], visited, allMethods, toImplement);
                ++i2;
            }
        }
    }

    private IMethodBinding[] evalUnimplementedMethods(ITypeBinding typeBinding) {
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethodBinding curr = typeMethods[i];
            int modifiers2 = curr.getModifiers();
            if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2))) {
                allMethods.add(curr);
            }
            ++i;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            typeMethods = superClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < typeMethods.length) {
                IMethodBinding curr = typeMethods[i2];
                modifiers = curr.getModifiers();
                if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || this.findMethod(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++i2;
            }
            superClass = superClass.getSuperclass();
        }
        int i3 = 0;
        while (i3 < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i3);
            modifiers = curr.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || curr.getDeclaringClass().isInterface()) && typeBinding != curr.getDeclaringClass()) {
                toImplement.add(curr);
            }
            ++i3;
        }
        HashSet visited = new HashSet();
        ITypeBinding curr = typeBinding;
        while (curr != null) {
            ITypeBinding[] superInterfaces = curr.getInterfaces();
            int i4 = 0;
            while (i4 < superInterfaces.length) {
                this.findUnimplementedInterfaceMethods(superInterfaces[i4], visited, allMethods, toImplement);
                ++i4;
            }
            curr = curr.getSuperclass();
        }
        return toImplement.toArray(new IMethodBinding[toImplement.size()]);
    }

    private IMethodBinding findMethod(IMethodBinding method, ArrayList allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i);
            if (Bindings.isEqualMethod(method, curr.getName(), curr.getParameterTypes())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public String getAdditionalProposalInfo() {
        try {
            this.getCompilationUnitChange();
            StringBuffer buf = new StringBuffer();
            buf.append("<b>");
            buf.append(CorrectionMessages.getFormattedString("UnimplementedMethodsCompletionProposal.info", String.valueOf(this.fMethodsToOverride.length)));
            buf.append("</b><ul>");
            int i = 0;
            while (i < this.fMethodsToOverride.length) {
                buf.append("<li>");
                buf.append(Bindings.asString((IBinding)this.fMethodsToOverride[i]));
                buf.append("</li>");
                ++i;
            }
            buf.append("</ul>");
            return buf.toString();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }
}

