/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TaskMarkerProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;

    public TaskMarkerProposal(ICompilationUnit cu, IProblemLocation location, int relevance) {
        super("", cu, relevance, null);
        this.fLocation = location;
        this.setDisplayName(CorrectionMessages.getString("TaskMarkerProposal.description"));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        Position pos;
        CompilationUnitChange change;
        block4: {
            change = super.createCompilationUnitChange(name, cu, rootEdit);
            pos = null;
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.acquire(change.getFile());
                pos = this.getUpdatedPosition(buffer);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (buffer == null) throw throwable;
                TextBuffer.release(buffer);
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (buffer == null) break block4;
            }
            TextBuffer.release(buffer);
        }
        if (pos != null) {
            rootEdit.addChild((TextEdit)new ReplaceEdit(pos.getOffset(), pos.getLength(), ""));
            return change;
        }
        rootEdit.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), ""));
        return change;
    }

    private Position getUpdatedPosition(TextBuffer buffer) {
        int end;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(buffer.getContent().toCharArray());
        int token = this.getSurroundingComment(scanner);
        if (token == 158) {
            return null;
        }
        int commentStart = scanner.getCurrentTokenStartPosition();
        int commentEnd = scanner.getCurrentTokenEndPosition() + 1;
        int contentStart = commentStart + 2;
        int contentEnd = commentEnd;
        if (token == 1003) {
            contentStart = commentStart + 3;
            contentEnd = commentEnd - 2;
        } else if (token == 1002) {
            contentEnd = commentEnd - 2;
        }
        if (this.hasContent(buffer, contentStart, this.fLocation.getOffset()) || this.hasContent(buffer, contentEnd, this.fLocation.getOffset() + this.fLocation.getLength())) {
            return new Position(this.fLocation.getOffset(), this.fLocation.getLength());
        }
        TextRegion startRegion = buffer.getLineInformationOfOffset(commentStart);
        int start = startRegion.getOffset();
        boolean contentAtBegining = this.hasContent(buffer, start, commentStart);
        if (contentAtBegining) {
            start = commentStart;
        }
        if (token == 1001) {
            end = contentAtBegining ? startRegion.getOffset() + startRegion.getLength() : commentEnd;
        } else {
            int endLine = buffer.getLineOfOffset(commentEnd - 1);
            if (endLine + 1 == buffer.getNumberOfLines() || contentAtBegining) {
                TextRegion endRegion = buffer.getLineInformation(endLine);
                end = endRegion.getOffset() + endRegion.getLength();
            } else {
                TextRegion endRegion = buffer.getLineInformation(endLine + 1);
                end = endRegion.getOffset();
            }
        }
        if (this.hasContent(buffer, commentEnd, end)) {
            end = commentEnd;
            start = commentStart;
        }
        return new Position(start, end - start);
    }

    private int getSurroundingComment(IScanner scanner) {
        try {
            int start = this.fLocation.getOffset();
            int end = start + this.fLocation.getLength();
            int token = scanner.getNextToken();
            while (token != 158) {
                if (TokenScanner.isComment(token)) {
                    int currStart = scanner.getCurrentTokenStartPosition();
                    int currEnd = scanner.getCurrentTokenEndPosition() + 1;
                    if (currStart <= start && end <= currEnd) {
                        return token;
                    }
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return 158;
    }

    private boolean hasContent(TextBuffer buf, int start, int end) {
        int i = start;
        while (i < end) {
            char ch = buf.getChar(i);
            if (!Character.isWhitespace(ch)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

