/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.MissingReturnTypeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class ReturnTypeSubProcessor {
    public static void addMethodWithConstrNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)selectedNode;
            ASTRewrite rewrite = new ASTRewrite((ASTNode)declaration);
            rewrite.markAsReplaced((ASTNode)declaration, 25, Boolean.TRUE, null);
            String label = CorrectionMessages.getString("ReturnTypeSubProcessor.constrnamemethod.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
    }

    public static void addVoidMethodReturnsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration && selectedNode.getNodeType() == 41) {
            ReturnStatement returnStatement = (ReturnStatement)selectedNode;
            Expression expr = returnStatement.getExpression();
            if (expr != null) {
                ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                if (binding == null) {
                    binding = selectedNode.getAST().resolveWellKnownType("java.lang.Object");
                }
                MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
                ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
                String label = CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.voidmethodreturns.description", binding.getName());
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
                String returnTypeName = proposal.addImport(binding);
                Type newReturnType = ASTNodeFactory.newType(astRoot.getAST(), returnTypeName);
                if (methodDeclaration.isConstructor()) {
                    rewrite.markAsReplaced((ASTNode)methodDeclaration, 25, Boolean.FALSE, null);
                    rewrite.markAsReplaced((ASTNode)methodDeclaration, 42, newReturnType, null);
                } else {
                    rewrite.markAsReplaced((ASTNode)methodDeclaration.getReturnType(), (ASTNode)newReturnType);
                }
                String key = "return_type";
                proposal.markAsLinked(rewrite, (ASTNode)newReturnType, true, key);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(astRoot.getAST(), binding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedModeProposal(key, bindings[i]);
                    ++i;
                }
                proposal.ensureNoModifications();
                proposals.add(proposal);
            }
            ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
            rewrite.markAsRemoved((ASTNode)returnStatement);
            String label = CorrectionMessages.getString("ReturnTypeSubProcessor.removereturn.description");
            Image image = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
    }

    public static void addMissingReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            PrimitiveType type;
            String typeName;
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ReturnStatementCollector eval = new ReturnStatementCollector();
            decl.accept((ASTVisitor)eval);
            ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
            typeBinding = Bindings.normalizeTypeBinding(typeBinding);
            ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
            AST ast = astRoot.getAST();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal("", cu, rewrite, 6, image);
            if (typeBinding != null) {
                typeName = proposal.addImport(typeBinding);
                type = ASTNodeFactory.newType(ast, typeName);
            } else {
                typeName = "void";
                type = ast.newPrimitiveType(PrimitiveType.VOID);
            }
            proposal.setDisplayName(CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.missingreturntype.description", typeName));
            rewrite.markAsReplaced((ASTNode)methodDeclaration, 42, type, null);
            rewrite.markAsReplaced((ASTNode)methodDeclaration, 25, Boolean.FALSE, null);
            String key = "return_type";
            proposal.markAsLinked(rewrite, (ASTNode)type, true, key);
            if (typeBinding != null) {
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(astRoot.getAST(), typeBinding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedModeProposal(key, bindings[i]);
                    ++i;
                }
            }
            proposal.ensureNoModifications();
            proposals.add(proposal);
            ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
            if (parentType instanceof TypeDeclaration) {
                String constructorName = ((TypeDeclaration)parentType).getName().getIdentifier();
                SimpleName nameNode = methodDeclaration.getName();
                String label = CorrectionMessages.getFormattedString("ReturnTypeSubProcessor.wrongconstructorname.description", constructorName);
                proposals.add(new ReplaceCorrectionProposal(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 5));
            }
        }
    }

    public static void addMissingReturnStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            Block block = methodDecl.getBody();
            if (block == null) {
                return;
            }
            ReturnStatement existingStatement = selectedNode instanceof ReturnStatement ? (ReturnStatement)selectedNode : null;
            proposals.add(new MissingReturnTypeCorrectionProposal(cu, methodDecl, existingStatement, 6));
            Type returnType = methodDecl.getReturnType();
            if (!"void".equals(ASTNodes.asString((ASTNode)returnType))) {
                ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDecl);
                AST ast = methodDecl.getAST();
                rewrite.markAsReplaced((ASTNode)returnType, (ASTNode)ast.newPrimitiveType(PrimitiveType.VOID));
                String label = CorrectionMessages.getString("ReturnTypeSubProcessor.changetovoid.description");
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
                proposal.ensureNoModifications();
                proposals.add(proposal);
            }
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList fResult = new ArrayList();

        ReturnStatementCollector() {
        }

        public Iterator returnStatements() {
            return this.fResult.iterator();
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            int i = 0;
            while (i < this.fResult.size()) {
                ReturnStatement node = (ReturnStatement)this.fResult.get(i);
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                } else {
                    return ast.resolveWellKnownType("void");
                }
                couldBeObject = true;
                ++i;
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }
    }
}

