/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class RemoveDeclarationCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private SimpleName fName;

    public RemoveDeclarationCorrectionProposal(ICompilationUnit cu, SimpleName name, int relevance) {
        super("", cu, null, relevance, JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.fName = name;
    }

    public String getDisplayString() {
        IBinding binding = this.fName.resolveBinding();
        String name = this.fName.getIdentifier();
        switch (binding.getKind()) {
            case 2: {
                return CorrectionMessages.getFormattedString("RemoveDeclarationCorrectionProposal.removeunusedtype.description", name);
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return CorrectionMessages.getFormattedString("RemoveDeclarationCorrectionProposal.removeunusedconstructor.description", name);
                }
                return CorrectionMessages.getFormattedString("RemoveDeclarationCorrectionProposal.removeunusedmethod.description", name);
            }
            case 3: {
                if (((IVariableBinding)binding).isField()) {
                    return CorrectionMessages.getFormattedString("RemoveDeclarationCorrectionProposal.removeunusedfield.description", name);
                }
                return CorrectionMessages.getFormattedString("RemoveDeclarationCorrectionProposal.removeunusedvar.description", name);
            }
        }
        return super.getDisplayString();
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite;
        IBinding binding = this.fName.resolveBinding();
        CompilationUnit root = (CompilationUnit)this.fName.getRoot();
        if (binding.getKind() != 3) {
            ASTNode declaration = root.findDeclaringNode(binding);
            rewrite = new ASTRewrite(declaration.getParent());
            rewrite.markAsRemoved(declaration);
        } else {
            CompilationUnit completeRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, this.fName.getStartPosition(), this.fName.getLength());
            rewrite = new ASTRewrite((ASTNode)completeRoot);
            SimpleName[] references = LinkedNodeFinder.perform((ASTNode)completeRoot, nameNode.resolveBinding());
            int i = 0;
            while (i < references.length) {
                this.removeVariableReferences(rewrite, references[i]);
                ++i;
            }
        }
        return rewrite;
    }

    private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference) {
        int nameParentType = reference.getParent().getNodeType();
        if (nameParentType == 7) {
            Assignment assignment = (Assignment)reference.getParent();
            Expression rightHand = assignment.getRightHandSide();
            ASTNode parent = assignment.getParent();
            if (parent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                this.removeVariableWithInitializer(rewrite, (ASTNode)rightHand, parent);
            } else {
                rewrite.markAsReplaced((ASTNode)assignment, rewrite.createCopy((ASTNode)rightHand));
            }
        } else if (nameParentType == 44) {
            rewrite.markAsRemoved(reference.getParent());
        } else if (nameParentType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)reference.getParent();
            ASTNode varDecl = frag.getParent();
            List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
            if (fragments.size() == 1) {
                rewrite.markAsRemoved(varDecl);
            } else {
                rewrite.markAsRemoved((ASTNode)frag);
            }
        }
    }

    private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode) {
        ArrayList sideEffectNodes = new ArrayList();
        initializerNode.accept((ASTVisitor)new SideEffectFinder(sideEffectNodes));
        int nSideEffects = sideEffectNodes.size();
        if (nSideEffects == 0) {
            rewrite.markAsRemoved(statementNode);
        }
    }

    private static class SideEffectFinder
    extends ASTVisitor {
        private ArrayList fSideEffectNodes;

        public SideEffectFinder(ArrayList res) {
            this.fSideEffectNodes = res;
        }

        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(MethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }
    }
}

