/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.Templates;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.part.FileEditorInput;

public class QuickTemplateProcessor
implements IQuickAssistProcessor {
    private static final String $_LINE_SELECTION = "${line_selection}";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IDocument document = this.getDocument(cu);
        int offset = context.getSelectionOffset();
        int length = context.getSelectionLength();
        try {
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            IRegion region = document.getLineInformation(endLine);
            return startLine < endLine || length > 0 && offset == region.getOffset() && length == region.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations != null && locations.length > 0) {
            return new IJavaCompletionProposal[0];
        }
        try {
            ICompilationUnit cu = context.getCompilationUnit();
            IDocument document = this.getDocument(cu);
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            IRegion endLineRegion = document.getLineInformation(endLine);
            if (startLine == endLine) {
                if (length == 0 || offset != endLineRegion.getOffset() || length != endLineRegion.getLength()) {
                    return null;
                }
            } else {
                offset = document.getLineOffset(startLine);
                length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
            }
            ArrayList resultingCollections = new ArrayList();
            this.collectSurroundTemplates(document, cu, offset, length, resultingCollections);
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, "", e));
        }
    }

    private IDocument getDocument(ICompilationUnit cu) throws JavaModelException {
        IFile file = (IFile)JavaModelUtil.toOriginal(cu).getResource();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(file));
        if (document == null) {
            return new Document(cu.getSource());
        }
        return document;
    }

    private void collectSurroundTemplates(IDocument document, ICompilationUnit cu, int offset, int length, Collection result) throws BadLocationException {
        CompilationUnitContextType contextType = (CompilationUnitContextType)ContextTypeRegistry.getInstance().getContextType("java");
        CompilationUnitContext context = contextType.createContext(document, offset, length, cu);
        context.setVariable("selection", document.get(offset, length));
        context.setForceEvaluation(true);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = Templates.getInstance().getTemplates();
        int i = 0;
        while (i != templates.length) {
            Template curr = templates[i];
            if (context.canEvaluate(curr) && curr.getContextTypeName().equals("java") && curr.getPattern().indexOf($_LINE_SELECTION) != -1) {
                TemplateProposal proposal = new TemplateProposal(curr, context, (IRegion)region, JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif"));
                Object[] arg = new String[]{curr.getName(), curr.getDescription()};
                proposal.setDisplayString(CorrectionMessages.getFormattedString("QuickTemplateProcessor.surround.label", arg));
                result.add(proposal);
            }
            ++i;
        }
    }
}

