/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodeConstants;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.AssignToVariableAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.swt.graphics.Image;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = this.getCoveringNode(context);
        if (coveringNode != null) {
            return QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, null) || this.getRenameLocalProposals(context, coveringNode, null) || this.getAssignToVariableProposals(context, coveringNode, null) || this.getUnWrapProposals(context, coveringNode, null) || this.getAssignParamToFieldProposals(context, coveringNode, null) || this.getJoinVariableProposals(context, coveringNode, null) || this.getAddFinallyProposals(context, coveringNode, null) || this.getAddElseProposals(context, coveringNode, null) || this.getSplitVariableProposals(context, coveringNode, null) || this.getAddBlockProposals(context, coveringNode, null);
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = this.getCoveringNode(context);
        if (coveringNode != null) {
            ArrayList resultingCollections = new ArrayList();
            this.getRenameLocalProposals(context, coveringNode, resultingCollections);
            if (locations == null || locations.length == 0) {
                QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, resultingCollections);
                this.getAssignToVariableProposals(context, coveringNode, resultingCollections);
                this.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
                this.getUnWrapProposals(context, coveringNode, resultingCollections);
                this.getSplitVariableProposals(context, coveringNode, resultingCollections);
                this.getJoinVariableProposals(context, coveringNode, resultingCollections);
                this.getAddFinallyProposals(context, coveringNode, resultingCollections);
                this.getAddElseProposals(context, coveringNode, resultingCollections);
                this.getAddBlockProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private boolean getJoinVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        ASTNode parent = node.getParent();
        if (!(parent instanceof VariableDeclarationFragment)) {
            return false;
        }
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
        IVariableBinding binding = fragment.resolveBinding();
        if (fragment.getInitializer() != null || binding == null || binding.isField()) {
            return false;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return false;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.perform(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 && names[0] != fragment.getName()) {
            return false;
        }
        SimpleName firstAccess = names[1];
        if (!(firstAccess.getParent() instanceof Assignment)) {
            return false;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLeftHandSide() != firstAccess) {
            return false;
        }
        ASTNode assignParent = assignment.getParent();
        if (!(assignParent instanceof ExpressionStatement || assignParent instanceof ForStatement && ((ForStatement)assignParent).initializers().contains(assignment))) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = new ASTRewrite(statement.getParent());
        AST ast = statement.getAST();
        String label = CorrectionMessages.getString("QuickAssistProcessor.joindeclaration.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        Expression placeholder = (Expression)rewrite.createMove((ASTNode)assignment.getRightHandSide());
        rewrite.markAsInsert((ASTNode)fragment, 23, (ASTNode)placeholder, null);
        if (assignParent instanceof ExpressionStatement) {
            int statementParent = assignParent.getParent().getNodeType();
            if (statementParent == 25 || statementParent == 61 || statementParent == 19 || statementParent == 24) {
                Block block = ast.newBlock();
                rewrite.markAsReplaced(assignParent, (ASTNode)block);
            } else {
                rewrite.markAsRemoved(assignParent);
            }
        } else {
            rewrite.markAsRemoved((ASTNode)assignment);
        }
        proposal.markAsSelection(rewrite, (ASTNode)fragment.getName());
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }

    private boolean getSplitVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        ExpressionStatement newStatement;
        VariableDeclarationStatement statement;
        ASTNode parent = node.getParent();
        if (!(parent instanceof VariableDeclarationFragment)) {
            return false;
        }
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
        if (fragment.getInitializer() == null) {
            return false;
        }
        ASTNode fragParent = fragment.getParent();
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
        } else if (fragParent instanceof VariableDeclarationExpression) {
            statement = (Statement)fragParent.getParent();
        } else {
            return false;
        }
        ASTNode statementParent = statement.getParent();
        int property = ASTNodeConstants.getPropertyOfNode((ASTNode)statement);
        Object container = ASTNodeConstants.getNodeChild(statementParent, property);
        if (!(container instanceof List)) {
            return false;
        }
        List list = (List)container;
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = new ASTRewrite(statement.getParent());
        AST ast = statement.getAST();
        String label = CorrectionMessages.getString("QuickAssistProcessor.splitdeclaration.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        int insertIndex = list.indexOf(statement);
        Expression placeholder = (Expression)rewrite.createMove((ASTNode)fragment.getInitializer());
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide(placeholder);
        assignment.setLeftHandSide((Expression)ast.newSimpleName(fragment.getName().getIdentifier()));
        if (statement instanceof VariableDeclarationStatement) {
            newStatement = ast.newExpressionStatement((Expression)assignment);
            ++insertIndex;
        } else {
            rewrite.markAsReplaced(fragment.getParent(), (ASTNode)assignment);
            VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
            newFrag.setName(ast.newSimpleName(fragment.getName().getIdentifier()));
            newFrag.setExtraDimensions(fragment.getExtraDimensions());
            VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)fragParent;
            VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
            newVarDec.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)oldVarDecl.getType()));
            newVarDec.setModifiers(oldVarDecl.getModifiers());
            newStatement = newVarDec;
        }
        rewrite.markAsInsertInOriginal(statementParent, property, (ASTNode)newStatement, insertIndex, null);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }

    private ASTNode getCoveringNode(IInvocationContext context) {
        NodeFinder finder = new NodeFinder(context.getSelectionOffset(), context.getSelectionLength());
        context.getASTRoot().accept((ASTVisitor)finder);
        return finder.getCoveringNode();
    }

    private boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return false;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding(typeBinding)) == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        AssignToVariableAssistProposal localProposal = new AssignToVariableAssistProposal(cu, 1, expressionStatement, typeBinding, 2);
        resultingCollections.add(localProposal);
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(cu, 2, expressionStatement, typeBinding, 1);
            resultingCollections.add(fieldProposal);
        }
        return false;
    }

    private boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, typeBinding, 1);
            resultingCollections.add(fieldProposal);
        }
        return true;
    }

    private boolean getAddFinallyProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        TryStatement tryStatement = ASTResolving.findParentTryStatement(node);
        if (tryStatement == null || tryStatement.getFinally() != null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (tryStatement != statement && tryStatement.getBody() != statement) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = new ASTRewrite((ASTNode)tryStatement);
        AST ast = tryStatement.getAST();
        Block finallyBody = ast.newBlock();
        rewrite.markAsInsert((ASTNode)tryStatement, 18, (ASTNode)finallyBody, null);
        String label = CorrectionMessages.getString("QuickAssistProcessor.addfinallyblock.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }

    private boolean getAddElseProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = new ASTRewrite((ASTNode)statement);
        AST ast = statement.getAST();
        Block body = ast.newBlock();
        rewrite.markAsInsert((ASTNode)ifStatement, 11, (ASTNode)body, null);
        String label = CorrectionMessages.getString("QuickAssistProcessor.addelseblock.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor(node, 12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!type.isSimpleType()) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
        ASTRewrite rewrite = new ASTRewrite((ASTNode)methodDeclaration);
        QuickAssistProcessor.removeCatchBlock(rewrite, methodDeclaration, catchClause);
        ITypeBinding binding = type.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptions())) {
            Name name = ((SimpleType)type).getName();
            Name newName = (Name)ASTNode.copySubtree((AST)catchClause.getAST(), (ASTNode)name);
            rewrite.markAsInsertBeforeOriginal((ASTNode)methodDeclaration, 50, (ASTNode)newName, null, null);
        }
        String label = CorrectionMessages.getString("QuickAssistProcessor.catchclausetothrows.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 4, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        rewrite = new ASTRewrite((ASTNode)methodDeclaration);
        QuickAssistProcessor.removeCatchBlock(rewrite, methodDeclaration, catchClause);
        String label2 = CorrectionMessages.getString("QuickAssistProcessor.removecatchclause.description");
        Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 5, image2);
        proposal2.ensureNoModifications();
        resultingCollections.add(proposal2);
        return true;
    }

    private static void removeCatchBlock(ASTRewrite rewrite, MethodDeclaration methodDeclaration, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null) {
            rewrite.markAsRemoved((ASTNode)catchClause);
        } else {
            List statements = tryStatement.getBody().statements();
            if (statements.size() > 0) {
                ASTNode placeholder = rewrite.collapseNodes(statements, 0, statements.size());
                rewrite.markAsReplaced((ASTNode)tryStatement, rewrite.createCopy(placeholder));
            } else {
                rewrite.markAsRemoved((ASTNode)tryStatement);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List thrownExcpetions) {
        int i = 0;
        while (i < thrownExcpetions.size()) {
            Name name = (Name)thrownExcpetions.get(i);
            ITypeBinding elem = (ITypeBinding)name.resolveBinding();
            if (elem != null && Bindings.isSuperType(elem, binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean getRenameLocalProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding == null || binding.getKind() == 1) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(context.getCompilationUnit(), name);
        resultingCollections.add(proposal);
        return true;
    }

    private ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopy((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                ASTNode placeholder = rewrite.collapseNodes(innerStatements, 0, nStatements);
                return rewrite.createCopy(placeholder);
            }
            return null;
        }
        return rewrite.createCopy(statement);
    }

    private boolean getUnWrapProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        MethodInvocation invocation;
        ASTNode outer = node;
        Block block = null;
        if (outer.getNodeType() == 8) {
            block = (Block)outer;
            outer = block.getParent();
        }
        Statement body = null;
        String label = null;
        if (outer instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)outer;
            Statement elseBlock = ifStatement.getElseStatement();
            if (elseBlock == null || elseBlock instanceof Block && ((Block)elseBlock).statements().isEmpty()) {
                body = ifStatement.getThenStatement();
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.ifstatement");
        } else if (outer instanceof WhileStatement) {
            body = ((WhileStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.whilestatement");
        } else if (outer instanceof ForStatement) {
            body = ((ForStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.forstatement");
        } else if (outer instanceof DoStatement) {
            body = ((DoStatement)outer).getBody();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.dostatement");
        } else if (outer instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)outer;
            if (tryStatement.catchClauses().isEmpty()) {
                body = tryStatement.getBody();
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.trystatement");
        } else if (outer instanceof AnonymousClassDeclaration) {
            List decls = ((AnonymousClassDeclaration)outer).bodyDeclarations();
            int i = 0;
            while (i < decls.size()) {
                ASTNode elem = (ASTNode)decls.get(i);
                if (elem instanceof MethodDeclaration) {
                    Block curr = ((MethodDeclaration)elem).getBody();
                    if (curr != null && !curr.statements().isEmpty()) {
                        if (body != null) {
                            return false;
                        }
                        body = curr;
                    }
                } else if (elem instanceof TypeDeclaration) {
                    return false;
                }
                ++i;
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.anonymous");
            outer = ASTResolving.findParentStatement(outer);
        } else if (outer instanceof Block) {
            body = block;
            outer = block;
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.block");
        } else if (outer instanceof ParenthesizedExpression) {
            ParenthesizedExpression expression = (ParenthesizedExpression)outer;
            body = expression.getExpression();
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.parenthesis");
        } else if (outer instanceof MethodInvocation && (invocation = (MethodInvocation)outer).arguments().size() == 1) {
            int kind;
            body = (ASTNode)invocation.arguments().get(0);
            if (invocation.getParent().getNodeType() == 21 && (kind = body.getNodeType()) != 7 && kind != 38 && kind != 37 && kind != 32 && kind != 48) {
                body = null;
            }
            label = CorrectionMessages.getString("QuickAssistProcessor.unwrap.methodinvocation");
        }
        if (body == null) {
            return false;
        }
        ASTRewrite rewrite = new ASTRewrite(outer.getParent());
        ASTNode inner = this.getCopyOfInner(rewrite, (ASTNode)body);
        if (inner == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        rewrite.markAsReplaced(outer, inner);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }

    private boolean getAddBlockProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement == null) {
            return false;
        }
        int childProperty = -1;
        Statement child = null;
        switch (statement.getNodeType()) {
            case 25: {
                Statement elseStatement;
                int selectionStart = context.getSelectionOffset();
                int selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
                Statement then = ((IfStatement)statement).getThenStatement();
                if (selectionEnd <= then.getStartPosition() + then.getLength()) {
                    if (then instanceof Block) break;
                    childProperty = 49;
                    child = then;
                    break;
                }
                if (selectionStart < then.getStartPosition() + then.getLength() || (elseStatement = ((IfStatement)statement).getElseStatement()) instanceof Block) break;
                childProperty = 11;
                child = elseStatement;
                break;
            }
            case 61: {
                Statement whileBody = ((WhileStatement)statement).getBody();
                if (whileBody instanceof Block) break;
                childProperty = 4;
                child = whileBody;
                break;
            }
            case 24: {
                Statement forBody = ((ForStatement)statement).getBody();
                if (forBody instanceof Block) break;
                childProperty = 4;
                child = forBody;
                break;
            }
            case 19: {
                Statement doBody = ((DoStatement)statement).getBody();
                if (doBody instanceof Block) break;
                childProperty = 4;
                child = doBody;
            }
        }
        if (child == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = new ASTRewrite((ASTNode)statement);
        ASTNode childPlaceholder = rewrite.createMove((ASTNode)child);
        Block replacingBody = ast.newBlock();
        replacingBody.statements().add(childPlaceholder);
        rewrite.markAsInsert((ASTNode)statement, childProperty, (ASTNode)replacingBody, null);
        String label = childProperty == 49 ? CorrectionMessages.getString("QuickAssistProcessor.replacethenwithblock.description") : (childProperty == 11 ? CorrectionMessages.getString("QuickAssistProcessor.replaceelsewithblock.description") : CorrectionMessages.getString("QuickAssistProcessor.replacebodywithblock.description"));
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 10, image);
        proposal.ensureNoModifications();
        resultingCollections.add(proposal);
        return true;
    }
}

