/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private int fId;
    private String[] fArguments;
    private int fOffset;
    private int fLength;

    public ProblemLocation(int offset, int length, IJavaAnnotation annotation) {
        this.fId = annotation.getId();
        this.fArguments = annotation.getArguments();
        this.fOffset = offset;
        this.fLength = length;
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
    }

    public int getProblemId() {
        return this.fId;
    }

    public String[] getProblemArguments() {
        return this.fArguments;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public ASTNode getCoveringNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((ASTVisitor)finder);
        return finder.getCoveringNode();
    }

    public ASTNode getCoveredNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((ASTVisitor)finder);
        return finder.getCoveredNode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] arg = this.fArguments;
        if (arg != null) {
            int i = 0;
            while (i < arg.length) {
                buf.append(arg[i]);
                buf.append('\n');
                ++i;
            }
        }
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        if ((code & Integer.MIN_VALUE) != 0) {
            buf.append("Annotation + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

