/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class NewVariableCompletionProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    public static final int CONST_FIELD = 4;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String KEY_INITIALIZER = "initializer";
    private int fVariableKind;
    private SimpleName fOriginalNode;
    private ITypeBinding fSenderBinding;

    public NewVariableCompletionProposal(String label, ICompilationUnit cu, int variableKind, SimpleName node, ITypeBinding senderBinding, int relevance, Image image) {
        super(label, cu, null, relevance, image);
        this.fVariableKind = variableKind;
        this.fOriginalNode = node;
        this.fSenderBinding = senderBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit cu = ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        if (this.fVariableKind == 3) {
            return this.doAddParam(cu);
        }
        if (this.fVariableKind == 2 || this.fVariableKind == 4) {
            return this.doAddField(cu);
        }
        return this.doAddLocal(cu);
    }

    private ASTRewrite doAddParam(CompilationUnit cu) throws CoreException {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (decl instanceof MethodDeclaration) {
            ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
            SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
            newDecl.setType(this.evaluateVariableType(ast));
            newDecl.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.markAsInsertBeforeOriginal((ASTNode)decl, 39, (ASTNode)newDecl, null, null);
            this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, KEY_TYPE);
            this.markAsLinked(rewrite, (ASTNode)node, true, KEY_NAME);
            this.markAsLinked(rewrite, (ASTNode)newDecl.getName(), false, KEY_NAME);
            return rewrite;
        }
        return null;
    }

    private boolean isAssigned(Statement statement, SimpleName name) {
        ExpressionStatement exstat;
        if (statement instanceof ExpressionStatement && (exstat = (ExpressionStatement)statement).getExpression() instanceof Assignment) {
            Assignment assignment = (Assignment)exstat.getExpression();
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private boolean isForStatementInit(Statement statement, SimpleName name) {
        ForStatement forStatement;
        List list;
        if (statement instanceof ForStatement && (list = (forStatement = (ForStatement)statement).initializers()).size() == 1 && list.get(0) instanceof Assignment) {
            Assignment assignment = (Assignment)list.get(0);
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private ASTRewrite doAddLocal(CompilationUnit cu) throws CoreException {
        Block body;
        AST ast = cu.getAST();
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)this.fOriginalNode);
        if (decl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)decl).getBody();
        } else if (decl instanceof Initializer) {
            body = ((Initializer)decl).getBody();
        } else {
            return null;
        }
        ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
        SimpleName[] names = this.getAllReferences(cu, body);
        ASTNode dominant = this.getDominantNode(names);
        Statement dominantStatement = ASTResolving.findParentStatement(dominant);
        SimpleName node = names[0];
        if (this.isAssigned(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
            VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
            newDecl.setType(this.evaluateVariableType(ast));
            Expression placeholder = (Expression)rewrite.createCopy((ASTNode)assignment.getRightHandSide());
            newDeclFrag.setInitializer(placeholder);
            newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.markAsReplaced((ASTNode)dominantStatement, (ASTNode)newDecl);
            this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, KEY_TYPE);
            this.markAsLinked(rewrite, (ASTNode)newDeclFrag.getName(), true, KEY_NAME);
            this.markAsSelection(rewrite, (ASTNode)newDecl);
            return rewrite;
        }
        if (dominant != dominantStatement && this.isForStatementInit(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression expression = ast.newVariableDeclarationExpression(frag);
            frag.setName(ast.newSimpleName(node.getIdentifier()));
            Expression placeholder = (Expression)rewrite.createCopy((ASTNode)assignment.getRightHandSide());
            frag.setInitializer(placeholder);
            expression.setType(this.evaluateVariableType(ast));
            rewrite.markAsReplaced((ASTNode)assignment, (ASTNode)expression);
            this.markAsLinked(rewrite, (ASTNode)expression.getType(), false, KEY_TYPE);
            this.markAsLinked(rewrite, (ASTNode)frag.getName(), true, KEY_NAME);
            this.markAsSelection(rewrite, (ASTNode)expression);
            return rewrite;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
        newDecl.setType(this.evaluateVariableType(ast));
        this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, KEY_TYPE);
        this.markAsLinked(rewrite, (ASTNode)node, true, KEY_NAME);
        this.markAsLinked(rewrite, (ASTNode)newDeclFrag.getName(), false, KEY_NAME);
        Statement statement = dominantStatement;
        List list = ASTNodes.getContainingList((ASTNode)statement);
        while (list == null && statement.getParent() instanceof Statement) {
            statement = (Statement)statement.getParent();
            list = ASTNodes.getContainingList((ASTNode)statement);
        }
        if (list != null) {
            list.add(list.indexOf(statement), newDecl);
            rewrite.markAsInserted((ASTNode)newDecl);
            return rewrite;
        }
        return rewrite;
    }

    private SimpleName[] getAllReferences(CompilationUnit cu, Block body) {
        IProblem[] problems = cu.getProblems();
        ArrayList<Object> res = new ArrayList<Object>();
        int bodyStart = body.getStartPosition();
        int bodyEnd = bodyStart + body.getLength();
        String name = this.fOriginalNode.getIdentifier();
        int i = 0;
        while (i < problems.length) {
            ASTNode node;
            IProblem curr = problems[i];
            int probStart = curr.getSourceStart();
            int probEnd = curr.getSourceEnd() + 1;
            if (curr.getID() == 50 && probStart > bodyStart && probEnd < bodyEnd && name.equals(curr.getArguments()[0]) && (node = NodeFinder.perform((ASTNode)body, probStart, probEnd - probStart)) instanceof SimpleName) {
                res.add(node);
            }
            ++i;
        }
        if (res.isEmpty()) {
            res.add(this.fOriginalNode);
        }
        SimpleName[] names = res.toArray(new SimpleName[res.size()]);
        if (res.size() > 0) {
            Arrays.sort(names, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((SimpleName)o1).getStartPosition() - ((SimpleName)o2).getStartPosition();
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
        }
        return names;
    }

    private ASTNode getDominantNode(SimpleName[] names) {
        SimpleName dominator = names[0];
        int i = 1;
        while (i < names.length) {
            SimpleName curr = names[i];
            if (curr != dominator) {
                ASTNode parent = this.getCommonParent((ASTNode)curr, (ASTNode)dominator);
                if (curr.getStartPosition() < dominator.getStartPosition()) {
                    dominator = curr;
                }
                while (dominator.getParent() != parent) {
                    dominator = dominator.getParent();
                }
            }
            ++i;
        }
        int parentKind = dominator.getParent().getNodeType();
        if (parentKind != 8 && parentKind != 24) {
            return dominator.getParent();
        }
        return dominator;
    }

    private ASTNode getCommonParent(ASTNode node1, ASTNode node2) {
        ASTNode parent = node1.getParent();
        while (parent != null && !ASTNodes.isParent(node2, parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private ASTRewrite doAddField(CompilationUnit astRoot) throws CoreException {
        SimpleName node = this.fOriginalNode;
        boolean isInDifferentCU = false;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
            isInDifferentCU = true;
        }
        if (newTypeDecl != null) {
            ASTRewrite rewrite = new ASTRewrite((ASTNode)astRoot);
            AST ast = newTypeDecl.getAST();
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(node.getIdentifier()));
            Type type = this.evaluateVariableType(ast);
            FieldDeclaration newDecl = ast.newFieldDeclaration(fragment);
            newDecl.setType(type);
            newDecl.setModifiers(this.evaluateFieldModifiers(newTypeDecl));
            if (this.fSenderBinding.isInterface() || this.fVariableKind == 4) {
                fragment.setInitializer(ASTNodeFactory.newDefaultExpression(ast, type, 0));
            }
            boolean isAnonymous = newTypeDecl.getNodeType() == 1;
            List decls = isAnonymous ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
            int insertIndex = this.findFieldInsertIndex(decls, node.getStartPosition());
            rewrite.markAsInsertInOriginal(newTypeDecl, 5, (ASTNode)newDecl, insertIndex, null);
            this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, KEY_TYPE);
            if (!isInDifferentCU) {
                this.markAsLinked(rewrite, (ASTNode)node, true, KEY_NAME);
            }
            this.markAsLinked(rewrite, (ASTNode)fragment.getName(), false, KEY_NAME);
            if (fragment.getInitializer() != null) {
                this.markAsLinked(rewrite, (ASTNode)fragment.getInitializer(), false, KEY_INITIALIZER);
            }
            return rewrite;
        }
        return null;
    }

    private int findFieldInsertIndex(List decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private Type evaluateVariableType(AST ast) throws CoreException {
        ITypeBinding binding = ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode);
        if (binding != null) {
            if (this.isVariableAssigned()) {
                ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, binding);
                int i = 0;
                while (i < typeProposals.length) {
                    this.addLinkedModeProposal(KEY_TYPE, typeProposals[i]);
                    ++i;
                }
            }
            String typeName = this.addImport(binding);
            return ASTNodeFactory.newType(ast, typeName);
        }
        Type type = ASTResolving.guessTypeForReference(ast, (ASTNode)this.fOriginalNode);
        if (type != null) {
            return type;
        }
        if (this.fVariableKind == 4) {
            return ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private boolean isVariableAssigned() {
        ASTNode parent = this.fOriginalNode.getParent();
        return parent instanceof Assignment && this.fOriginalNode == ((Assignment)parent).getLeftHandSide();
    }

    private int evaluateFieldModifiers(ASTNode newTypeDecl) {
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDecls = ((TypeDeclaration)newTypeDecl).getFields();
            if (fieldDecls.length > 0) {
                return fieldDecls[0].getModifiers();
            }
            return 0;
        }
        int modifiers = 0;
        if (this.fVariableKind == 4) {
            modifiers |= 0x18;
        } else {
            ASTNode parent = this.fOriginalNode.getParent();
            if (parent instanceof QualifiedName) {
                IBinding qualifierBinding = ((QualifiedName)parent).getQualifier().resolveBinding();
                if (qualifierBinding instanceof ITypeBinding) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                modifiers |= 8;
            }
        }
        ASTNode node = ASTResolving.findParentType((ASTNode)this.fOriginalNode);
        modifiers = newTypeDecl.equals((Object)node) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration ? (modifiers |= 4) : (modifiers |= 1));
        return modifiers;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

