/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.swt.graphics.Image;

public class NewMethodCompletionProposal
extends LinkedCorrectionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private ASTNode fNode;
    private List fArguments;
    private ITypeBinding fSenderBinding;

    public NewMethodCompletionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, List arguments, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, null, relevance, image);
        this.fNode = invocationNode;
        this.fArguments = arguments;
        this.fSenderBinding = binding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            isInDifferentCU = false;
            newTypeDecl = typeDecl;
        } else {
            isInDifferentCU = true;
            astRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newTypeDecl != null) {
            Name invocationName;
            ASTRewrite rewrite = new ASTRewrite((ASTNode)astRoot);
            List members = this.fSenderBinding.isAnonymous() ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
            MethodDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            int insertIndex = this.isConstructor() ? this.findConstructorInsertIndex(members) : (!isInDifferentCU ? this.findMethodInsertIndex(members, this.fNode.getStartPosition()) : members.size());
            rewrite.markAsInsertInOriginal(newTypeDecl, 5, (ASTNode)newStub, insertIndex, null);
            if (!isInDifferentCU && (invocationName = this.getInvocationName()) != null) {
                this.markAsLinked(rewrite, (ASTNode)invocationName, true, KEY_NAME);
            }
            this.markAsLinked(rewrite, (ASTNode)newStub.getName(), false, KEY_NAME);
            if (!newStub.isConstructor()) {
                this.markAsLinked(rewrite, (ASTNode)newStub.getReturnType(), false, KEY_TYPE);
            }
            return rewrite;
        }
        return null;
    }

    private boolean isConstructor() {
        return this.fNode.getNodeType() != 32 && this.fNode.getNodeType() != 48;
    }

    private MethodDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        String string;
        AST ast = targetTypeDecl.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(this.isConstructor());
        decl.setModifiers(this.evaluateModifiers(targetTypeDecl));
        decl.setName(ast.newSimpleName(this.getMethodName()));
        List arguments = this.fArguments;
        List params = decl.parameters();
        int nArguments = arguments.size();
        ArrayList<String> takenNames = new ArrayList<String>(nArguments);
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            takenNames.add(declaredFields[i].getName());
            ++i;
        }
        i = 0;
        while (i < arguments.size()) {
            Expression elem = (Expression)arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            String argTypeKey = "arg_type_" + i;
            Type type = this.evaluateParameterTypes(ast, elem, argTypeKey);
            param.setType(type);
            String argNameKey = "arg_name_" + i;
            String name = this.evaluateParameterNames(takenNames, elem, type, argNameKey);
            param.setName(ast.newSimpleName(name));
            params.add(param);
            this.markAsLinked(rewrite, (ASTNode)param.getType(), false, argTypeKey);
            this.markAsLinked(rewrite, (ASTNode)param.getName(), false, argNameKey);
            ++i;
        }
        Block body = null;
        String bodyStatement = "";
        if (!this.isConstructor()) {
            Type returnType = this.evaluateMethodType(ast);
            if (returnType == null) {
                decl.setReturnType((Type)ast.newPrimitiveType(PrimitiveType.VOID));
            } else {
                decl.setReturnType(returnType);
            }
            if (!this.fSenderBinding.isInterface() && returnType != null) {
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTNodeFactory.newDefaultExpression(ast, returnType, 0));
                bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, String.valueOf('\n'));
            }
        }
        if (!this.fSenderBinding.isInterface()) {
            body = ast.newBlock();
            String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), this.fSenderBinding.getName(), this.getMethodName(), this.isConstructor(), bodyStatement, String.valueOf('\n'));
            if (placeHolder != null) {
                ASTNode todoNode = rewrite.createPlaceholder(placeHolder, 4);
                body.statements().add(todoNode);
            }
        }
        decl.setBody(body);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (settings.createComments && !this.fSenderBinding.isAnonymous() && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), this.fSenderBinding.getName(), decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createPlaceholder(string, 8);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private int findMethodInsertIndex(List decls, int currPos) {
        int nDecls = decls.size();
        int i = 0;
        while (i < nDecls) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof MethodDeclaration && currPos < curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            ++i;
        }
        return nDecls;
    }

    private int findConstructorInsertIndex(List decls) {
        int nDecls = decls.size();
        int lastMethod = 0;
        int i = nDecls - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof MethodDeclaration) {
                if (((MethodDeclaration)curr).isConstructor()) {
                    return i + 1;
                }
                lastMethod = i;
            }
            --i;
        }
        return lastMethod;
    }

    private Name getInvocationName() {
        if (this.fNode instanceof MethodInvocation) {
            return ((MethodInvocation)this.fNode).getName();
        }
        if (this.fNode instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)this.fNode).getName();
        }
        if (this.fNode instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)this.fNode).getName();
        }
        return null;
    }

    private String getMethodName() {
        if (this.fNode instanceof MethodInvocation) {
            return ((MethodInvocation)this.fNode).getName().getIdentifier();
        }
        if (this.fNode instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)this.fNode).getName().getIdentifier();
        }
        return this.fSenderBinding.getName();
    }

    private int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.fSenderBinding.isInterface()) {
            MethodDeclaration[] methodDecls = ((TypeDeclaration)targetTypeDecl).getMethods();
            if (methodDecls.length > 0) {
                return methodDecls[0].getModifiers();
            }
            return 0;
        }
        if (this.fNode instanceof MethodInvocation) {
            ASTNode node;
            int modifiers = 0;
            Expression expression = ((MethodInvocation)this.fNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext(this.fNode)) {
                modifiers |= 8;
            }
            modifiers = targetTypeDecl.equals((Object)(node = ASTResolving.findParentType(this.fNode))) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration && ASTNodes.isParent(node, targetTypeDecl) ? (modifiers |= 4) : (modifiers |= 1));
            return modifiers;
        }
        return 1;
    }

    private Type evaluateMethodType(AST ast) throws CoreException {
        ITypeBinding binding = ASTResolving.guessBindingForReference(this.fNode);
        if (binding != null) {
            String typeName = this.addImport(binding);
            return ASTNodeFactory.newType(ast, typeName);
        }
        ASTNode parent = this.fNode.getParent();
        if (parent instanceof ExpressionStatement) {
            return null;
        }
        Type type = ASTResolving.guessTypeForReference(ast, this.fNode);
        if (type != null) {
            return type;
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private Type evaluateParameterTypes(AST ast, Expression elem, String key) throws CoreException {
        ITypeBinding binding = Bindings.normalizeTypeBinding(elem.resolveTypeBinding());
        if (binding != null) {
            ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, binding);
            int i = 0;
            while (i < typeProposals.length) {
                this.addLinkedModeProposal(key, typeProposals[i]);
                ++i;
            }
            String typeName = this.addImport(binding);
            return ASTNodeFactory.newType(ast, typeName);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private String evaluateParameterNames(ArrayList takenNames, Expression argNode, Type type, String key) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] excludedNames = takenNames.toArray(new String[takenNames.size()]);
        String favourite = null;
        if (argNode instanceof SimpleName) {
            SimpleName name = (SimpleName)argNode;
            favourite = StubUtility.suggestArgumentName(project, name.getIdentifier(), excludedNames);
        }
        int dim = 0;
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            dim = arrayType.getDimensions();
            type = arrayType.getElementType();
        }
        String typeName = ASTNodes.asString((ASTNode)type);
        String packName = Signature.getQualifier((String)typeName);
        String[] names = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)packName, (String)typeName, (int)dim, (String[])excludedNames);
        if (favourite == null) {
            favourite = names[0];
        }
        int i = 0;
        while (i < names.length) {
            this.addLinkedModeProposal(key, names[i]);
            ++i;
        }
        takenNames.add(favourite);
        return favourite;
    }
}

