/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierChangeCompletionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;

    public static void addNonAccessibleMemberProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind, int relevance) throws JavaModelException {
        String name;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        if (binding instanceof IMethodBinding) {
            typeBinding = ((IMethodBinding)binding).getDeclaringClass();
            name = String.valueOf(binding.getName()) + "()";
        } else if (binding instanceof IVariableBinding) {
            typeBinding = ((IVariableBinding)binding).getDeclaringClass();
            name = binding.getName();
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            name = binding.getName();
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource()) {
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            if (kind == 2) {
                excludedModifiers = 7;
                includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding);
                label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changevisibility.description", new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            } else if (kind == 1) {
                label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertostatic.description", name);
                includedModifiers = 8;
            } else if (kind == 4) {
                label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertononstatic.description", name);
                excludedModifiers = 8;
            } else if (kind == 3) {
                label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertodefault.description", name);
                excludedModifiers = 2;
            } else {
                return;
            }
            ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding);
            if (targetCU != null) {
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal(label, targetCU, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            }
        }
    }

    public static void addNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertofinal.description", binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        return "default";
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ASTRewrite rewrite;
        boolean hasNoBody;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
        }
        boolean bl = hasNoBody = decl.getBody() == null;
        if (problem.getProblemId() == 67109227 || parentIsAbstractClass) {
            rewrite = new ASTRewrite(decl.getParent());
            AST ast = astRoot.getAST();
            int newModifiers = decl.getModifiers() & 0xFFFFFBFF;
            rewrite.markAsReplaced((ASTNode)decl, 34, new Integer(newModifiers), null);
            if (hasNoBody) {
                Block newBody = ast.newBlock();
                rewrite.markAsInserted((ASTNode)newBody);
                decl.setBody(newBody);
                Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType(), decl.getExtraDimensions());
                if (expr != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removeabstract.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposal.ensureNoModifications();
            proposals.add(proposal);
        }
        if (!hasNoBody && problem.getProblemId() == 603979889) {
            rewrite = new ASTRewrite(decl.getParent());
            rewrite.markAsRemoved((ASTNode)decl.getBody());
            String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removebody.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposal2.ensureNoModifications();
            proposals.add(proposal2);
        }
        if (problem.getProblemId() == 67109227 && parentTypeDecl != null) {
            ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMakeTypeStaticProposal(cu, parentTypeDecl, 5);
            proposals.add(proposal);
        }
    }

    public static void addNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTRewrite rewrite = new ASTRewrite(decl.getParent());
        AST ast = astRoot.getAST();
        int newModifiers = decl.getModifiers() & 0xFFFFFEFF;
        rewrite.markAsReplaced((ASTNode)decl, 34, new Integer(newModifiers), null);
        Block newBody = ast.newBlock();
        rewrite.markAsInserted((ASTNode)newBody);
        decl.setBody(newBody);
        Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType(), decl.getExtraDimensions());
        if (expr != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removenative.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
        proposal.ensureNoModifications();
        proposals.add(proposal);
        if (decl.getBody() != null) {
            rewrite = new ASTRewrite(decl.getParent());
            rewrite.markAsRemoved((ASTNode)decl.getBody());
            String label2 = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removebody.description");
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 5, image2);
            proposal2.ensureNoModifications();
            proposals.add(proposal2);
        }
    }

    public static ASTRewriteCorrectionProposal getMakeTypeStaticProposal(ICompilationUnit cu, TypeDeclaration typeDeclaration, int relevance) throws CoreException {
        ASTRewrite rewrite = new ASTRewrite(typeDeclaration.getParent());
        int newModifiers = typeDeclaration.getModifiers() | 0x400;
        rewrite.markAsReplaced((ASTNode)typeDeclaration, 34, new Integer(newModifiers), null);
        String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.addabstract.description", typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.ensureNoModifications();
        return proposal;
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        Expression expression;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = new ASTRewrite((ASTNode)decl);
        int newModifiers = decl.getModifiers() & 0xFFFFFBFF;
        rewrite.markAsReplaced((ASTNode)decl, 34, new Integer(newModifiers), null);
        Block body = ast.newBlock();
        decl.setBody(body);
        rewrite.markAsInserted((ASTNode)body);
        Type returnType = decl.getReturnType();
        if (!decl.isConstructor() && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType, decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.addmissingbody.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
        proposal.ensureNoModifications();
        proposals.add(proposal);
    }

    public static void addNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertofinal.description", binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }
}

