/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ModifierChangeCompletionProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private ASTNode fNode;
    private int fIncludedModifiers;
    private int fExcludedModifiers;

    public ModifierChangeCompletionProposal(String label, ICompilationUnit targetCU, IBinding binding, ASTNode node, int includedModifiers, int excludedModifiers, int relevance, Image image) {
        super(label, targetCU, null, relevance, image);
        this.fBinding = binding;
        this.fNode = node;
        this.fIncludedModifiers = includedModifiers;
        this.fExcludedModifiers = excludedModifiers;
    }

    protected ASTRewrite getRewrite() {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode boundNode = astRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        GroupDescription selectionDescription = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            selectionDescription = new GroupDescription("selection");
            this.setSelectionDescription(selectionDescription);
            CompilationUnit newRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            ASTRewrite rewrite = new ASTRewrite(declNode.getParent());
            if (declNode instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)declNode;
                int newModifiers = methodDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                rewrite.markAsReplaced((ASTNode)methodDecl, 34, new Integer(newModifiers), selectionDescription);
            } else if (declNode instanceof VariableDeclarationFragment) {
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    int newModifiers = fieldDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    rewrite.markAsReplaced((ASTNode)fieldDecl, 34, new Integer(newModifiers), selectionDescription);
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    int newModifiers = varDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    rewrite.markAsReplaced((ASTNode)varDecl, 34, new Integer(newModifiers), selectionDescription);
                } else if (parent instanceof VariableDeclarationExpression) {
                    VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                    int newModifiers = varDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                    rewrite.markAsReplaced((ASTNode)varDecl, 34, new Integer(newModifiers), selectionDescription);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                int newModifiers = variableDeclaration.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                rewrite.markAsReplaced((ASTNode)variableDeclaration, 34, new Integer(newModifiers), selectionDescription);
            } else if (declNode instanceof TypeDeclaration) {
                TypeDeclaration typeDecl = (TypeDeclaration)declNode;
                int newModifiers = typeDecl.getModifiers() & ~this.fExcludedModifiers | this.fIncludedModifiers;
                rewrite.markAsReplaced((ASTNode)typeDecl, 34, new Integer(newModifiers), selectionDescription);
            }
            return rewrite;
        }
        return null;
    }
}

