/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class MissingReturnTypeCorrectionProposal
extends LinkedCorrectionProposal {
    private static final String RETURN_EXPRESSION_KEY = "value";
    private MethodDeclaration fMethodDecl;
    private ReturnStatement fExistingReturn;

    public MissingReturnTypeCorrectionProposal(ICompilationUnit cu, MethodDeclaration decl, ReturnStatement existingReturn, int relevance) {
        super("", cu, null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fMethodDecl = decl;
        this.fExistingReturn = existingReturn;
    }

    public String getDisplayString() {
        if (this.fExistingReturn != null) {
            return CorrectionMessages.getString("MissingReturnTypeCorrectionProposal.changereturnstatement.description");
        }
        return CorrectionMessages.getString("MissingReturnTypeCorrectionProposal.addreturnstatement.description");
    }

    protected ASTRewrite getRewrite() {
        Expression expression;
        ITypeBinding binding;
        AST ast = this.fMethodDecl.getAST();
        ITypeBinding returnBinding = this.getReturnTypeBinding();
        if (this.fExistingReturn != null) {
            ASTRewrite rewrite = new ASTRewrite(this.fExistingReturn.getParent());
            Expression expression2 = this.evaluateReturnExpressions(ast, returnBinding, this.fExistingReturn.getStartPosition());
            if (expression2 != null) {
                this.fExistingReturn.setExpression(expression2);
                rewrite.markAsInserted((ASTNode)expression2);
                this.markAsLinked(rewrite, (ASTNode)expression2, true, RETURN_EXPRESSION_KEY);
            }
            return rewrite;
        }
        ASTRewrite rewrite = new ASTRewrite((ASTNode)this.fMethodDecl);
        Block block = this.fMethodDecl.getBody();
        List statements = block.statements();
        int nStatements = statements.size();
        ASTNode lastStatement = null;
        if (nStatements > 0) {
            lastStatement = (ASTNode)statements.get(nStatements - 1);
        }
        if (returnBinding != null && lastStatement instanceof ExpressionStatement && lastStatement.getNodeType() != 7 && (binding = (expression = ((ExpressionStatement)lastStatement).getExpression()).resolveTypeBinding()) != null && TypeRules.canAssign(binding, returnBinding)) {
            Expression placeHolder = (Expression)rewrite.createMove((ASTNode)expression);
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(placeHolder);
            rewrite.markAsReplaced(lastStatement, (ASTNode)returnStatement);
            return rewrite;
        }
        int offset = lastStatement == null ? block.getStartPosition() + 1 : lastStatement.getStartPosition() + lastStatement.getLength();
        ReturnStatement returnStatement = ast.newReturnStatement();
        Expression expression3 = this.evaluateReturnExpressions(ast, returnBinding, offset);
        returnStatement.setExpression(expression3);
        statements.add(returnStatement);
        rewrite.markAsInserted((ASTNode)returnStatement);
        this.markAsLinked(rewrite, (ASTNode)returnStatement.getExpression(), true, RETURN_EXPRESSION_KEY);
        return rewrite;
    }

    private ITypeBinding getReturnTypeBinding() {
        IMethodBinding methodBinding = this.fMethodDecl.resolveBinding();
        if (methodBinding != null && methodBinding.getReturnType() != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }

    private Expression evaluateReturnExpressions(AST ast, ITypeBinding returnBinding, int returnOffset) {
        CompilationUnit root = (CompilationUnit)this.fMethodDecl.getRoot();
        SimpleName result = null;
        if (returnBinding != null) {
            ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
            IBinding[] bindings = analyzer.getDeclarationsInScope(returnOffset, 2);
            int i = 0;
            while (i < bindings.length) {
                IVariableBinding curr = (IVariableBinding)bindings[i];
                ITypeBinding type = curr.getType();
                if (type != null && TypeRules.canAssign(type, returnBinding) && this.testModifier(curr)) {
                    if (result == null) {
                        result = ast.newSimpleName(curr.getName());
                    }
                    this.addLinkedModeProposal(RETURN_EXPRESSION_KEY, curr.getName());
                }
                ++i;
            }
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, this.fMethodDecl.getReturnType(), this.fMethodDecl.getExtraDimensions());
        this.addLinkedModeProposal(RETURN_EXPRESSION_KEY, ASTNodes.asString((ASTNode)defaultExpression));
        if (result == null) {
            return defaultExpression;
        }
        return result;
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic((int)modifiers) || Modifier.isStatic((int)this.fMethodDecl.getModifiers());
    }
}

