/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionGroup;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIControl;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class LinkedNamesAssistProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2 {
    private SimpleName fNode;
    private IRegion fSelectedRegion;
    private ICompilationUnit fCompilationUnit;

    public LinkedNamesAssistProposal(ICompilationUnit cu, SimpleName node) {
        this.fNode = node;
        this.fCompilationUnit = cu;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, final int offset) {
        try {
            CompilationUnit root = AST.parseCompilationUnit((ICompilationUnit)this.fCompilationUnit, (boolean)true);
            SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)root, this.fNode.getStartPosition(), this.fNode.getLength());
            SimpleName[] sameNodes = LinkedNodeFinder.perform((ASTNode)root, nameNode.resolveBinding());
            Arrays.sort(sameNodes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return this.rank((ASTNode)o1) - this.rank((ASTNode)o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - offset;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            IDocument document = viewer.getDocument();
            LinkedPositionGroup group = new LinkedPositionGroup();
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                group.createPosition(document, elem.getStartPosition(), elem.getLength(), i);
                ++i;
            }
            LinkedEnvironment enviroment = new LinkedEnvironment();
            enviroment.addGroup(group);
            enviroment.forceInstall();
            LinkedUIControl ui = new LinkedUIControl(enviroment, viewer);
            ui.setExitPosition(viewer, offset, 0, false);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.getString("LinkedNamesAssistProposal.proposalinfo");
    }

    public String getDisplayString() {
        return CorrectionMessages.getString("LinkedNamesAssistProposal.description");
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 1;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

