/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class LinkedCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private GroupDescription fSelectionDescription = null;
    private List fLinkedPositions = null;
    private Map fLinkProposals = null;

    public LinkedCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, rewrite, relevance, image);
    }

    protected GroupDescription getSelectionDescription() {
        return this.fSelectionDescription;
    }

    protected GroupDescription[] getLinkedRanges() {
        if (this.fLinkedPositions != null && !this.fLinkedPositions.isEmpty()) {
            return this.fLinkedPositions.toArray(new GroupDescription[this.fLinkedPositions.size()]);
        }
        return null;
    }

    public GroupDescription markAsSelection(ASTRewrite rewrite, ASTNode node) {
        this.fSelectionDescription = new GroupDescription("selection");
        rewrite.markAsTracked(node, this.fSelectionDescription);
        return this.fSelectionDescription;
    }

    protected ICompletionProposal[] getLinkedModeProposals(String name) {
        if (this.fLinkProposals == null) {
            return null;
        }
        List proposals = (List)this.fLinkProposals.get(name);
        if (proposals != null) {
            ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
            if (res.length > 1) {
                Arrays.sort(res, 1, res.length - 1, new JavaCompletionProposalComparator());
            }
            return res;
        }
        return null;
    }

    public void addLinkedModeProposal(String name, String proposal) {
        this.addLinkedModeProposal(name, new LinkedModeProposal(proposal));
    }

    public void addLinkedModeProposal(String name, ITypeBinding proposal) {
        this.addLinkedModeProposal(name, new LinkedModeProposal(this.getCompilationUnit(), proposal));
    }

    public void addLinkedModeProposal(String name, IJavaCompletionProposal proposal) {
        ArrayList<IJavaCompletionProposal> proposals;
        if (this.fLinkProposals == null) {
            this.fLinkProposals = new HashMap();
        }
        if ((proposals = (ArrayList<IJavaCompletionProposal>)this.fLinkProposals.get(name)) == null) {
            proposals = new ArrayList<IJavaCompletionProposal>(10);
            this.fLinkProposals.put(name, proposals);
        }
        proposals.add(proposal);
    }

    public GroupDescription markAsLinked(ASTRewrite rewrite, ASTNode node, boolean isFirst, String kind) {
        GroupDescription description = new GroupDescription(kind);
        rewrite.markAsTracked(node, description);
        if (this.fLinkedPositions == null) {
            this.fLinkedPositions = new ArrayList();
        }
        if (isFirst) {
            this.fLinkedPositions.add(0, description);
        } else {
            this.fLinkedPositions.add(description);
        }
        return description;
    }

    public void setSelectionDescription(GroupDescription desc) {
        this.fSelectionDescription = desc;
    }

    public static class LinkedModeProposal
    implements IJavaCompletionProposal,
    ICompletionProposalExtension2 {
        private String fProposal;
        private ITypeBinding fTypeProposal;
        private ICompilationUnit fCompilationUnit;

        public LinkedModeProposal(String proposal) {
            this.fProposal = proposal;
        }

        public LinkedModeProposal(ICompilationUnit unit, ITypeBinding typeProposal) {
            this(typeProposal.getName());
            this.fTypeProposal = typeProposal;
            this.fCompilationUnit = unit;
        }

        private ImportsStructure getImportStructure() throws CoreException {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold(store);
            ImportsStructure impStructure = new ImportsStructure(this.fCompilationUnit, prefOrder, threshold, true);
            return impStructure;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            IDocument document = viewer.getDocument();
            Point point = viewer.getSelectedRange();
            try {
                String replaceString = this.fProposal;
                ImportsStructure impStructure = null;
                if (this.fTypeProposal != null) {
                    impStructure = this.getImportStructure();
                    replaceString = impStructure.addImport(this.fTypeProposal);
                }
                document.replace(point.x, point.y, replaceString);
                if (impStructure != null) {
                    impStructure.create(false, null);
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        public String getDisplayString() {
            if (this.fTypeProposal == null || this.fTypeProposal.getPackage() == null) {
                return this.fProposal;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(this.fProposal);
            buf.append(JavaElementLabels.CONCAT_STRING);
            if (this.fTypeProposal.getPackage().isUnnamed()) {
                buf.append(JavaElementLabels.DEFAULT_PACKAGE);
            } else {
                buf.append(this.fTypeProposal.getPackage().getName());
            }
            return buf.toString();
        }

        public Image getImage() {
            if (this.fTypeProposal != null) {
                ITypeBinding binding = this.fTypeProposal;
                if (binding.isArray()) {
                    binding = this.fTypeProposal.getElementType();
                }
                if (binding.isPrimitive()) {
                    return null;
                }
                ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(binding.isInterface(), binding.isMember(), binding.getModifiers());
                return JavaPlugin.getImageDescriptorRegistry().get(descriptor);
            }
            return null;
        }

        public int getRelevance() {
            return 0;
        }

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            return false;
        }
    }
}

