/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocTag;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class JavadocTagsSubProcessor {
    public static void getMissingJavadocCommentProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (declaration == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
        if (binding == null) {
            return;
        }
        if (declaration instanceof MethodDeclaration) {
            String string;
            MethodDeclaration methodDecl = (MethodDeclaration)declaration;
            IMethodBinding methodBinding = methodDecl.resolveBinding();
            if (methodBinding != null) {
                methodBinding = Bindings.findDeclarationInHierarchy(binding, methodBinding.getName(), methodBinding.getParameterTypes());
            }
            if ((string = CodeGeneration.getMethodComment(cu, binding.getName(), methodDecl, methodBinding, String.valueOf('\n'))) != null) {
                String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.method.description");
                proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), string, label));
            }
        } else if (declaration instanceof TypeDeclaration) {
            String typeQualifiedName = Bindings.getTypeQualifiedName(binding);
            String string = CodeGeneration.getTypeComment(cu, typeQualifiedName, String.valueOf('\n'));
            if (string != null) {
                String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.type.description");
                proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), string, label));
            }
        } else if (declaration instanceof FieldDeclaration) {
            String comment = "/**\n *\n */\n";
            List fragments = ((FieldDeclaration)declaration).fragments();
            if (fragments != null && fragments.size() > 0) {
                VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                String fieldName = decl.getName().getIdentifier();
                String typeName = binding.getName();
                comment = CodeGeneration.getFieldComment(cu, typeName, fieldName, String.valueOf('\n'));
            }
            String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.field.description");
            proposals.add(JavadocTagsSubProcessor.getNewJavadocTagProposal(cu, declaration.getStartPosition(), comment, label));
        }
    }

    private static CUCorrectionProposal getNewJavadocTagProposal(ICompilationUnit cu, int insertPosition, String comment, String label) throws CoreException {
        CUCorrectionProposal cUCorrectionProposal;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
        CUCorrectionProposal proposal = new CUCorrectionProposal(label, cu, 1, image);
        TextBuffer buffer = TextBuffer.acquire((IFile)cu.getResource());
        try {
            int tabWidth = CodeFormatterUtil.getTabWidth();
            int line = buffer.getLineOfOffset(insertPosition);
            String lineContent = buffer.getLineContent(line);
            String indentString = Strings.getIndentString(lineContent, tabWidth);
            String str = Strings.changeIndent(comment, 0, tabWidth, indentString, buffer.getLineDelimiter());
            TextEdit rootEdit = proposal.getRootTextEdit();
            InsertEdit edit = new InsertEdit(insertPosition, str);
            rootEdit.addChild((TextEdit)edit);
            if (comment.charAt(comment.length() - 1) != '\n') {
                rootEdit.addChild((TextEdit)new InsertEdit(insertPosition, buffer.getLineDelimiter()));
                rootEdit.addChild((TextEdit)new InsertEdit(insertPosition, indentString));
            }
            cUCorrectionProposal = proposal;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        TextBuffer.release(buffer);
        return cUCorrectionProposal;
    }

    public static void getMissingJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        Type type;
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (!(declaration instanceof MethodDeclaration)) {
            return;
        }
        Javadoc javadoc = declaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)declaration;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
        JavadocRewriteProposal proposal = new JavadocRewriteProposal("", context.getCompilationUnit(), javadoc, 1, image);
        JavaDocTag[] existingTags = proposal.getTags();
        switch (problem.getProblemId()) {
            case -1610612265: {
                String name = ASTNodes.asString(node);
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.paramtag.description"));
                int insertPosition = JavadocTagsSubProcessor.findParamInsertPosition(existingTags, methodDecl, node.getParent());
                proposal.insertNewTag(insertPosition, new JavaDocTag("param", name));
                break;
            }
            case -1610612261: {
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.returntag.description"));
                int insertPosition = JavadocTagsSubProcessor.findReturnInsertPosition(existingTags);
                proposal.insertNewTag(insertPosition, new JavaDocTag("return", ""));
                break;
            }
            case -1610612259: {
                String name = ASTNodes.asString(node);
                proposal.setDisplayName(CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.throwstag.description"));
                int insertPosition = JavadocTagsSubProcessor.findThrowsInsertPosition(existingTags, methodDecl, node);
                proposal.insertNewTag(insertPosition, new JavaDocTag("throws", name));
                break;
            }
            default: {
                return;
            }
        }
        proposals.add(proposal);
        String label = CorrectionMessages.getString("JavadocTagsSubProcessor.addjavadoc.allmissing.description");
        JavadocRewriteProposal addAllMissing = new JavadocRewriteProposal(label, context.getCompilationUnit(), javadoc, 5, image);
        List list = methodDecl.parameters();
        int i = 0;
        while (i < list.size()) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)list.get(i);
            String name = decl.getName().getIdentifier();
            if (JavadocTagsSubProcessor.findTag(existingTags, "param", name) == null) {
                int insertPosition = JavadocTagsSubProcessor.findParamInsertPosition(existingTags, methodDecl, (ASTNode)decl);
                addAllMissing.insertNewTag(insertPosition, new JavaDocTag("param", name));
            }
            ++i;
        }
        if (!(methodDecl.isConstructor() || (type = methodDecl.getReturnType()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessor.findTag(existingTags, "return", null) != null)) {
            int insertPosition = JavadocTagsSubProcessor.findReturnInsertPosition(existingTags);
            addAllMissing.insertNewTag(insertPosition, new JavaDocTag("return", ""));
        }
        List throwsExceptions = methodDecl.thrownExceptions();
        int i2 = 0;
        while (i2 < throwsExceptions.size()) {
            String name;
            Name exception = (Name)throwsExceptions.get(i2);
            ITypeBinding binding = exception.resolveTypeBinding();
            if (binding != null && JavadocTagsSubProcessor.findThrowsTag(existingTags, name = binding.getName()) == null) {
                int insertPosition = JavadocTagsSubProcessor.findThrowsInsertPosition(existingTags, methodDecl, (ASTNode)exception);
                addAllMissing.insertNewTag(insertPosition, new JavaDocTag("throws", name));
            }
            ++i2;
        }
        proposals.add(addAllMissing);
    }

    private static JavaDocTag findTag(JavaDocTag[] existingTags, String name, String arg) {
        int i = 0;
        while (i < existingTags.length) {
            JavaDocTag curr = existingTags[i];
            if (name.equals(curr.getName())) {
                if (arg != null) {
                    String argument = JavadocTagsSubProcessor.getArgument(curr.getContent());
                    if (argument.equals(arg)) {
                        return curr;
                    }
                } else {
                    return curr;
                }
            }
            ++i;
        }
        return null;
    }

    private static JavaDocTag findThrowsTag(JavaDocTag[] existingTags, String arg) {
        int i = 0;
        while (i < existingTags.length) {
            String argument;
            JavaDocTag curr = existingTags[i];
            String currName = curr.getName();
            if (("throws".equals(currName) || "exception".equals(currName)) && ((argument = JavadocTagsSubProcessor.getArgument(curr.getContent())).equals(arg) || Signature.getSimpleName((String)argument).equals(arg))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static int findThrowsInsertPosition(JavaDocTag[] tags, MethodDeclaration methodDecl, ASTNode node) {
        HashSet<String> previousArgs = new HashSet<String>();
        List list = methodDecl.thrownExceptions();
        int i = 0;
        while (i < list.size() && node != list.get(i)) {
            Name curr = (Name)list.get(i);
            previousArgs.add(ASTResolving.getSimpleName(curr));
            ++i;
        }
        int lastThrows = tags.length;
        int i2 = tags.length - 1;
        while (i2 >= 0) {
            JavaDocTag curr = tags[i2];
            if ("throws".equals(curr.getName())) {
                String arg = JavadocTagsSubProcessor.getArgument(curr.getContent());
                if (previousArgs.contains(arg) || previousArgs.contains(Signature.getSimpleName((String)arg))) {
                    return i2 + 1;
                }
                lastThrows = i2;
            }
            --i2;
        }
        return lastThrows;
    }

    private static int findReturnInsertPosition(JavaDocTag[] tags) {
        int res = tags.length;
        int i = tags.length - 1;
        while (i >= 0) {
            JavaDocTag curr = tags[i];
            if ("throws".equals(curr.getName())) {
                res = i;
            } else if ("param".equals(curr.getName())) {
                return i + 1;
            }
            --i;
        }
        return res;
    }

    private static int findParamInsertPosition(JavaDocTag[] tags, MethodDeclaration methodDecl, ASTNode node) {
        Object curr;
        HashSet<String> previousArgs = new HashSet<String>();
        List list = methodDecl.parameters();
        int i = 0;
        while (i < list.size() && list.get(i) != node) {
            curr = (SingleVariableDeclaration)list.get(i);
            previousArgs.add(curr.getName().getIdentifier());
            ++i;
        }
        i = tags.length - 1;
        while (i >= 0) {
            String arg;
            curr = tags[i];
            if ("param".equals(((JavaDocTag)curr).getName()) && previousArgs.contains(arg = JavadocTagsSubProcessor.getArgument(((JavaDocTag)curr).getContent()))) {
                return i + 1;
            }
            --i;
        }
        if (tags.length > 0 && tags[0].getName() == null) {
            return 1;
        }
        return 0;
    }

    private static String getArgument(String content) {
        int i = 0;
        while (i < content.length() && !Character.isWhitespace(content.charAt(i))) {
            ++i;
        }
        return content.substring(0, i);
    }

    private static class JavadocRewriteProposal
    extends CUCorrectionProposal {
        private Javadoc fJavadoc;
        private JavaDocTag[] fOriginalTags;
        private List fChangedList;

        public JavadocRewriteProposal(String name, ICompilationUnit cu, Javadoc javadoc, int relevance, Image image) throws JavaModelException {
            super(name, cu, relevance, image);
            this.fJavadoc = javadoc;
            this.fOriginalTags = JavaDocAccess.getJavaDocTags((IOpenable)cu, javadoc.getStartPosition(), javadoc.getLength());
            this.fChangedList = new ArrayList();
            int i = 0;
            while (i < this.fOriginalTags.length) {
                JavaDocTag curr = this.fOriginalTags[i];
                this.fChangedList.add(new Event(curr, curr));
                ++i;
            }
        }

        public JavaDocTag[] getTags() {
            return this.fOriginalTags;
        }

        public void insertNewTag(int index, JavaDocTag tag) {
            if (index < 0 || index > this.fOriginalTags.length) {
                throw new IllegalArgumentException();
            }
            int count = 0;
            int insertPos = 0;
            while (insertPos < this.fChangedList.size()) {
                Event curr = (Event)this.fChangedList.get(insertPos);
                if (!curr.isInserted()) {
                    if (count == index) break;
                    ++count;
                }
                ++insertPos;
            }
            this.fChangedList.add(insertPos, new Event(null, tag));
        }

        /*
         * Exception decompiling
         */
        protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->58)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void createEdits(TextBuffer buffer, ICompilationUnit cu, TextEdit root) {
            int currPos = this.fJavadoc.getStartPosition() + 3;
            boolean needsLead = true;
            boolean isLast = false;
            int i = 0;
            while (i < this.fChangedList.size()) {
                Event curr = (Event)this.fChangedList.get(i);
                if (curr.isInserted()) {
                    StringBuffer buf = new StringBuffer();
                    if (needsLead) {
                        buf.append('\n');
                    }
                    buf.append(this.getNewTagString(curr.newTag));
                    if (!needsLead && !isLast) {
                        buf.append('\n');
                    }
                    String indentString = String.valueOf(this.getIndent(buffer)) + " * ";
                    String str = Strings.changeIndent(buf.toString(), 0, CodeFormatterUtil.getTabWidth(), indentString, buffer.getLineDelimiter());
                    if (isLast) {
                        str = "* " + str + buffer.getLineDelimiter() + this.getIndent(buffer) + ' ';
                    }
                    root.addChild((TextEdit)new InsertEdit(currPos, str));
                } else {
                    JavaDocTag original = curr.originalTag;
                    currPos = original.getOffset() + original.getLength();
                    needsLead = false;
                    isLast = this.fOriginalTags.length > 0 && this.fOriginalTags[this.fOriginalTags.length - 1] == original;
                }
                ++i;
            }
        }

        private String getNewTagString(JavaDocTag newTag) {
            StringBuffer buf = new StringBuffer();
            if (newTag.getName() != null) {
                buf.append('@');
                buf.append(newTag.getName());
                if (newTag.getContent().length() > 0) {
                    buf.append(' ');
                }
            }
            buf.append(newTag.getContent());
            return buf.toString();
        }

        private String getIndent(TextBuffer buffer) {
            String line = buffer.getLineContentOfOffset(this.fJavadoc.getStartPosition());
            String indent = Strings.getIndentString(line, CodeFormatterUtil.getTabWidth());
            return indent;
        }

        private static class Event {
            JavaDocTag originalTag;
            JavaDocTag newTag;

            public Event(JavaDocTag originalTag, JavaDocTag newTag) {
                this.originalTag = originalTag;
                this.newTag = newTag;
            }

            public boolean isInserted() {
                return this.originalTag == null && this.newTag != null;
            }

            public boolean isRemoved() {
                return this.originalTag != null && this.newTag == null;
            }
        }
    }
}

