/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JavaCorrectionProcessor
implements IContentAssistProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fContributedAssistProcessors = null;
    private static ContributedProcessorDescriptor[] fContributedCorrectionProcessors = null;
    private static String fErrorMessage;
    private JavaCorrectionAssistant fAssistant;

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String contributionId) {
        IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui", contributionId);
        ArrayList<ContributedProcessorDescriptor> res = new ArrayList<ContributedProcessorDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ContributedProcessorDescriptor desc = new ContributedProcessorDescriptor(elements[i]);
            IStatus status = desc.checkSyntax();
            if (status.isOK()) {
                res.add(desc);
            } else {
                JavaPlugin.log(status);
            }
            ++i;
        }
        return res.toArray(new ContributedProcessorDescriptor[res.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fContributedCorrectionProcessors == null) {
            fContributedCorrectionProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID);
        }
        return fContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fContributedAssistProcessors == null) {
            fContributedAssistProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID);
        }
        return fContributedAssistProcessors;
    }

    public static boolean hasCorrections(ICompilationUnit cu, int problemId) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getCorrectionProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IQuickFixProcessor processor = (IQuickFixProcessor)processors[i].getProcessor(cu);
                if (processor != null && processor.hasCorrections(cu, problemId)) {
                    return true;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        return false;
    }

    public static boolean hasCorrections(IJavaAnnotation annotation) {
        int problemId = annotation.getId();
        if (problemId == -1) {
            if (annotation instanceof MarkerAnnotation) {
                return JavaCorrectionProcessor.hasCorrections(((MarkerAnnotation)annotation).getMarker());
            }
        } else {
            ICompilationUnit cu = annotation.getCompilationUnit();
            if (cu != null) {
                return JavaCorrectionProcessor.hasCorrections(cu, problemId);
            }
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(IInvocationContext context) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getAssistProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IQuickAssistProcessor processor = (IQuickAssistProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (processor != null && processor.hasAssists(context)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return false;
    }

    public JavaCorrectionProcessor(JavaCorrectionAssistant assistant) {
        this.fAssistant = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IEditorPart part = this.fAssistant.getEditor();
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(part.getEditorInput());
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)part.getEditorInput());
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        AssistContext context = new AssistContext(cu, documentOffset, length);
        fErrorMessage = null;
        ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
        if (model != null) {
            this.processProblemAnnotations(context, model, proposals);
        }
        if (proposals.isEmpty()) {
            proposals.add(new ChangeCorrectionProposal(CorrectionMessages.getString("NoCorrectionProposal.description"), null, 0, null));
        }
        ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(res, new CorrectionsComparator());
        return res;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void processProblemAnnotations(IInvocationContext context, IAnnotationModel model, ArrayList proposals) {
        int offset = context.getSelectionOffset();
        ArrayList<ProblemLocation> problems = new ArrayList<ProblemLocation>();
        JavaAnnotationIterator iter = new JavaAnnotationIterator(model, true);
        while (iter.hasNext()) {
            IJavaAnnotation annot = (IJavaAnnotation)iter.next();
            Position pos = model.getPosition((Annotation)annot);
            if (!this.isAtPosition(offset, pos)) continue;
            int problemId = annot.getId();
            if (problemId != -1) {
                problems.add(new ProblemLocation(pos.getOffset(), pos.getLength(), annot));
                continue;
            }
            if (!(annot instanceof MarkerAnnotation)) continue;
            IMarker marker = ((MarkerAnnotation)annot).getMarker();
            IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
            if (res.length <= 0) continue;
            int i = 0;
            while (i < res.length) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        JavaCorrectionProcessor.collectCorrections(context, problemLocations, proposals);
        if (!this.fAssistant.isUpdatedOffset()) {
            JavaCorrectionProcessor.collectAssists(context, problemLocations, proposals);
        }
    }

    public static void collectCorrections(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getCorrectionProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IJavaCompletionProposal[] res;
                IQuickFixProcessor curr = (IQuickFixProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (curr != null && (res = curr.getCorrections(context, locations)) != null) {
                    int k = 0;
                    while (k < res.length) {
                        proposals.add(res[k]);
                        ++k;
                    }
                }
            }
            catch (Exception e) {
                fErrorMessage = CorrectionMessages.getString("JavaCorrectionProcessor.error.quickfix.message");
                JavaPlugin.log(e);
            }
            ++i;
        }
    }

    public static void collectAssists(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getAssistProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IJavaCompletionProposal[] res;
                IQuickAssistProcessor curr = (IQuickAssistProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (curr != null && (res = curr.getAssists(context, locations)) != null) {
                    int k = 0;
                    while (k < res.length) {
                        proposals.add(res[k]);
                        ++k;
                    }
                }
            }
            catch (Exception e) {
                fErrorMessage = CorrectionMessages.getString("JavaCorrectionProcessor.error.quickassist.message");
                JavaPlugin.log(e);
            }
            ++i;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return fErrorMessage;
    }

    private static class CorrectionsComparator
    implements Comparator {
        private static Collator fgCollator = Collator.getInstance();

        CorrectionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IJavaCompletionProposal && o2 instanceof IJavaCompletionProposal) {
                IJavaCompletionProposal e1 = (IJavaCompletionProposal)o1;
                IJavaCompletionProposal e2 = (IJavaCompletionProposal)o2;
                int del = e2.getRelevance() - e1.getRelevance();
                if (del != 0) {
                    return del;
                }
                return fgCollator.compare(e1.getDisplayString(), e2.getDisplayString());
            }
            return fgCollator.compare(((ICompletionProposal)o1).getDisplayString(), ((ICompletionProposal)o2).getDisplayString());
        }
    }
}

