/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CorrectPackageDeclarationProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;

    public CorrectPackageDeclarationProposal(ICompilationUnit cu, IProblemLocation location, int relevance) {
        super(CorrectionMessages.getString("CorrectPackageDeclarationProposal.name"), cu, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.packd_obj.gif"));
        this.fLocation = location;
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit root) throws CoreException {
        CompilationUnitChange change = super.createCompilationUnitChange(name, cu, root);
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        IPackageDeclaration[] decls = cu.getPackageDeclarations();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            int i = 0;
            while (i < decls.length) {
                ISourceRange range = decls[i].getSourceRange();
                root.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                ++i;
            }
            return change;
        }
        if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
            String str = "package " + parentPack.getElementName() + ";" + lineDelim + lineDelim;
            root.addChild((TextEdit)new InsertEdit(0, str));
            return change;
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), parentPack.getElementName()));
        return change;
    }

    public String getDisplayString() {
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        try {
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (parentPack.isDefaultPackage() && decls.length > 0) {
                return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.remove.description", decls[0].getElementName());
            }
            if (!parentPack.isDefaultPackage() && decls.length == 0) {
                return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.add.description", parentPack.getElementName());
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return CorrectionMessages.getFormattedString("CorrectPackageDeclarationProposal.change.description", parentPack.getElementName());
    }
}

