/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private String fOldName;
    private String fNewName;

    public CorrectMainTypeNameProposal(ICompilationUnit cu, String oldTypeName, int relevance) {
        super("", cu, null, relevance, null);
        this.fNewName = Signature.getQualifier((String)cu.getElementName());
        this.setDisplayName(CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.renametype.description", this.fNewName));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fOldName = oldTypeName;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        char[] content = this.getCompilationUnit().getBuffer().getCharacters();
        CompilationUnit astRoot = AST.parseCompilationUnit((char[])content, (String)(String.valueOf(this.fOldName) + ".java"), (IJavaProject)this.getCompilationUnit().getJavaProject());
        ASTRewrite rewrite = new ASTRewrite((ASTNode)astRoot);
        AST ast = astRoot.getAST();
        TypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            ITypeBinding binding = decl.resolveBinding();
            if (binding != null) {
                SimpleName[] sameNodes = LinkedNodeFinder.perform((ASTNode)astRoot, (IBinding)binding);
                int i = 0;
                while (i < sameNodes.length) {
                    rewrite.markAsReplaced((ASTNode)sameNodes[i], (ASTNode)ast.newSimpleName(this.fNewName));
                    ++i;
                }
            } else {
                rewrite.markAsReplaced((ASTNode)decl.getName(), (ASTNode)ast.newSimpleName(this.fNewName));
            }
        }
        return rewrite;
    }

    private TypeDeclaration findTypeDeclaration(List types, String name) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            TypeDeclaration decl = (TypeDeclaration)iter.next();
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

