/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionParser;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.VariablePool;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;

public class ContributedProcessorDescriptor {
    private IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private ICompilationUnit fLastCUnit;
    private boolean fLastResult;
    private static final String ID = "id";
    private static final String CLASS = "class";

    public ContributedProcessorDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fLastCUnit = null;
    }

    public IStatus checkSyntax() {
        String id = this.fConfigurationElement.getAttribute(ID);
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            return new StatusInfo(4, "Only one <enablement> element allowed. Disabling " + id);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    private boolean matches(ICompilationUnit cunit) throws CoreException {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            if (cunit.equals(this.fLastCUnit)) {
                return this.fLastResult;
            }
            ExpressionParser parser = ExpressionParser.getStandard();
            Expression expression = parser.parse(children[0]);
            this.fLastResult = expression.evaluate(new VariablePool(null, cunit, cunit)) == TestResult.TRUE;
            this.fLastCUnit = cunit;
            return this.fLastResult;
        }
        return true;
    }

    public Object getProcessor(ICompilationUnit cunit) throws CoreException {
        if (this.matches(cunit)) {
            if (this.fProcessorInstance == null) {
                this.fProcessorInstance = this.fConfigurationElement.createExecutableExtension(CLASS);
            }
            return this.fProcessorInstance;
        }
        return null;
    }
}

