/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(ICompilationUnit cu, TypeDeclaration typeNode, IMethodBinding superConstructor, int relevance) {
        super(null, cu, null, relevance, null);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    public Image getImage() {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE));
    }

    public String getDisplayString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
                ++i;
            }
        }
        buf.append(')');
        return CorrectionMessages.getFormattedString("ConstructorFromSuperclassProposal.description", buf.toString());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = new ASTRewrite((ASTNode)this.fTypeNode);
        AST ast = this.fTypeNode.getAST();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (!settings.createComments) {
            settings = null;
        }
        MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, settings);
        rewrite.markAsInserted((ASTNode)newMethodDecl);
        this.fTypeNode.bodyDeclarations().add(0, newMethodDecl);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, MethodDeclaration newStub) {
        List parameters = newStub.parameters();
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)parameters.get(i);
            this.markAsLinked(rewrite, (ASTNode)curr.getType(), false, "arg_type_" + i);
            this.markAsLinked(rewrite, (ASTNode)curr.getName(), false, "arg_name_" + i);
            ++i;
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        String bodyStatement = "";
        if (binding == null) {
            decl.setModifiers(1);
        } else {
            decl.setModifiers(binding.getModifiers());
            List parameters = decl.parameters();
            ITypeBinding[] params = binding.getParameterTypes();
            String[] paramNames = this.getArgumentNames(binding);
            int i = 0;
            while (i < params.length) {
                String paramTypeName = this.addImport(params[i]);
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                var.setType(ASTNodeFactory.newType(ast, paramTypeName));
                var.setName(ast.newSimpleName(paramNames[i]));
                parameters.add(var);
                ++i;
            }
            List thrownExceptions = decl.thrownExceptions();
            ITypeBinding[] excTypes = binding.getExceptionTypes();
            int i2 = 0;
            while (i2 < excTypes.length) {
                String excTypeName = this.addImport(excTypes[i2]);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++i2;
            }
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            List arguments = invocation.arguments();
            int i3 = 0;
            while (i3 < paramNames.length) {
                SimpleName argument = ast.newSimpleName(paramNames[i3]);
                arguments.add(argument);
                this.markAsLinked(rewrite, (ASTNode)argument, false, "arg_name_" + i3);
                ++i3;
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, String.valueOf('\n'));
        }
        String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), name, name, true, bodyStatement, String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createPlaceholder(placeHolder, 4);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), name, decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createPlaceholder(string, 8);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IJavaProject project = this.getCompilationUnit().getJavaProject();
                IMethod method = Bindings.findMethod(binding, project);
                if (method != null) {
                    return StubUtility.suggestArgumentNames(project, method.getParameterNames());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String[] names = new String[nParams];
        int i = 0;
        while (i < names.length) {
            names[i] = "arg" + i;
            ++i;
        }
        return names;
    }
}

