/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ChangeMethodSignatureProposal
extends LinkedCorrectionProposal {
    private ASTNode fInvocationNode;
    private IMethodBinding fSenderBinding;
    private ChangeDescription[] fParameterChanges;

    public ChangeMethodSignatureProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, IMethodBinding binding, ChangeDescription[] changes, int relevance, Image image) {
        super(label, targetCU, null, relevance, image);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
        this.fParameterChanges = changes;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        CompilationUnit astRoot = (CompilationUnit)this.fInvocationNode.getRoot();
        ASTNode methodDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newMethodDecl = null;
        if (methodDecl != null) {
            isInDifferentCU = false;
            newMethodDecl = methodDecl;
        } else {
            isInDifferentCU = true;
            astRoot = AST.parseCompilationUnit((ICompilationUnit)this.getCompilationUnit(), (boolean)true);
            newMethodDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newMethodDecl instanceof MethodDeclaration) {
            ASTRewrite rewrite = new ASTRewrite((ASTNode)astRoot);
            this.modifySignature(rewrite, (MethodDeclaration)newMethodDecl, isInDifferentCU);
            return rewrite;
        }
        return null;
    }

    private void modifySignature(ASTRewrite rewrite, MethodDeclaration methodDecl, boolean isInDifferentCU) throws CoreException {
        List parameters = methodDecl.parameters();
        SingleVariableDeclaration[] oldParameters = parameters.toArray(new SingleVariableDeclaration[parameters.size()]);
        AST ast = methodDecl.getAST();
        int k = 0;
        ArrayList<String> usedNames = new ArrayList<String>();
        boolean hasCreatedVariables = false;
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaringClass().getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            usedNames.add(declaredFields[i].getName());
            ++i;
        }
        i = 0;
        while (i < this.fParameterChanges.length) {
            String type;
            SingleVariableDeclaration newNode;
            ModifyDescription desc;
            ChangeDescription curr = this.fParameterChanges[i];
            if (curr == null) {
                usedNames.add(oldParameters[k].getName().getIdentifier());
                ++k;
            } else if (curr instanceof InsertDescription) {
                desc = (InsertDescription)curr;
                newNode = ast.newSingleVariableDeclaration();
                type = this.addImport(desc.type);
                newNode.setType(ASTNodeFactory.newType(ast, type));
                desc.resultingNode = newNode;
                hasCreatedVariables = true;
                rewrite.markAsInserted((ASTNode)newNode);
                parameters.add(i, newNode);
            } else if (curr instanceof RemoveDescription) {
                rewrite.markAsRemoved((ASTNode)oldParameters[k]);
                ++k;
            } else if (curr instanceof EditDescription) {
                desc = (EditDescription)curr;
                newNode = ast.newSingleVariableDeclaration();
                type = this.addImport(((EditDescription)desc).type);
                newNode.setType(ASTNodeFactory.newType(ast, type));
                ((EditDescription)desc).resultingNode = newNode;
                hasCreatedVariables = true;
                rewrite.markAsReplaced((ASTNode)oldParameters[k], (ASTNode)newNode);
                ++k;
            } else if (curr instanceof SwapDescription) {
                SingleVariableDeclaration decl1 = oldParameters[k];
                SingleVariableDeclaration decl2 = oldParameters[((SwapDescription)curr).index];
                rewrite.markAsReplaced((ASTNode)decl1, rewrite.createCopy((ASTNode)decl2));
                rewrite.markAsReplaced((ASTNode)decl2, rewrite.createCopy((ASTNode)decl1));
                usedNames.add(decl1.getName().getIdentifier());
                ++k;
            }
            ++i;
        }
        if (!hasCreatedVariables) {
            return;
        }
        if (methodDecl.getBody() != null) {
            CompilationUnit root = (CompilationUnit)methodDecl.getRoot();
            IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsAfter(methodDecl.getBody().getStartPosition(), 2);
            int i2 = 0;
            while (i2 < bindings.length) {
                usedNames.add(bindings[i2].getName());
                ++i2;
            }
        }
        this.fixupNames(rewrite, usedNames, isInDifferentCU);
    }

    private void fixupNames(ASTRewrite rewrite, ArrayList usedNames, boolean isInDifferentCU) {
        AST ast = rewrite.getAST();
        int i = 0;
        while (i < this.fParameterChanges.length) {
            ChangeDescription curr = this.fParameterChanges[i];
            if (curr instanceof ModifyDescription) {
                ModifyDescription desc = (ModifyDescription)curr;
                SingleVariableDeclaration var = desc.resultingNode;
                String suggestedName = desc.name;
                String typeKey = "param_type_" + i;
                String nameKey = "param_name_" + i;
                String favourite = null;
                String[] excludedNames = usedNames.toArray(new String[usedNames.size()]);
                if (suggestedName != null) {
                    favourite = StubUtility.suggestArgumentName(this.getCompilationUnit().getJavaProject(), suggestedName, excludedNames);
                    this.addLinkedModeProposal(nameKey, favourite);
                }
                Type type = var.getType();
                int dim = 0;
                if (type.isArrayType()) {
                    dim = ((ArrayType)type).getDimensions();
                    type = ((ArrayType)type).getElementType();
                }
                String[] suggestedNames = NamingConventions.suggestArgumentNames((IJavaProject)this.getCompilationUnit().getJavaProject(), (String)"", (String)ASTNodes.asString((ASTNode)type), (int)dim, (String[])excludedNames);
                int k = 0;
                while (k < suggestedNames.length) {
                    this.addLinkedModeProposal(nameKey, suggestedNames[k]);
                    ++k;
                }
                if (favourite == null) {
                    favourite = suggestedNames[0];
                }
                var.setName(ast.newSimpleName(favourite));
                usedNames.add(favourite);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, desc.type);
                int k2 = 0;
                while (k2 < bindings.length) {
                    this.addLinkedModeProposal(typeKey, bindings[k2]);
                    ++k2;
                }
                this.markAsLinked(rewrite, (ASTNode)var.getType(), false, typeKey);
                this.markAsLinked(rewrite, (ASTNode)var.getName(), false, nameKey);
            }
            ++i;
        }
    }

    public static interface ChangeDescription {
    }

    public static class SwapDescription
    implements ChangeDescription {
        int index;

        public SwapDescription(int index) {
            this.index = index;
        }
    }

    public static class RemoveDescription
    implements ChangeDescription {
    }

    private static class ModifyDescription
    implements ChangeDescription {
        String name;
        ITypeBinding type;
        SingleVariableDeclaration resultingNode;

        public ModifyDescription(ITypeBinding type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class EditDescription
    extends ModifyDescription {
        public EditDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    public static class InsertDescription
    extends ModifyDescription {
        public InsertDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }
}

