/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.link.LinkedEnvironment;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionGroup;
import org.eclipse.jdt.internal.ui.text.link.LinkedUIControl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private TextEdit fRootEdit;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, ICompilationUnit cu, int relevance) {
        this(name, cu, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
    }

    public CUCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image) {
        super(name, null, relevance, image);
        this.fRootEdit = new MultiTextEdit();
        this.fCompilationUnit = cu;
    }

    public CUCorrectionProposal(String name, CompilationUnitChange change, int relevance, Image image) {
        super(name, change, relevance, image);
        this.fCompilationUnit = change.getCompilationUnit();
    }

    protected CompilationUnitChange createCompilationUnitChange(String name, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        CompilationUnitChange change = new CompilationUnitChange(name, cu);
        change.setEdit(rootEdit);
        change.setSave(false);
        this.setChange(change);
        return change;
    }

    protected Change getChange() throws CoreException {
        Change change = super.getChange();
        if (change == null) {
            return this.createCompilationUnitChange(this.getDisplayString(), this.fCompilationUnit, this.fRootEdit);
        }
        return change;
    }

    protected final void addEdits(CompilationUnitChange change) throws CoreException {
    }

    protected GroupDescription[] getLinkedRanges() {
        return null;
    }

    protected ICompletionProposal[] getLinkedModeProposals(String name) {
        return null;
    }

    protected GroupDescription getSelectionDescription() {
        return null;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        try {
            CompilationUnitChange change = this.getCompilationUnitChange();
            TextBuffer previewConent = change.getPreviewTextBuffer();
            String currentConentString = change.getCurrentContent();
            JavaTokenComparator leftSide = new JavaTokenComparator(previewConent.getContent(), true);
            JavaTokenComparator rightSide = new JavaTokenComparator(currentConentString, true);
            RangeDifference[] differences = RangeDifferencer.findRanges((IRangeComparator)leftSide, (IRangeComparator)rightSide);
            int i = 0;
            while (i < differences.length) {
                RangeDifference curr = differences[i];
                int start = leftSide.getTokenStart(curr.leftStart());
                int end = leftSide.getTokenStart(curr.leftEnd());
                if (curr.kind() == 2 && curr.leftLength() > 0) {
                    buf.append("<b>");
                    this.appendContent(previewConent, start, end, buf, false);
                    buf.append("</b>");
                } else if (curr.kind() == 0) {
                    this.appendContent(previewConent, start, end, buf, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(TextBuffer text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        int startLine = text.getLineOfOffset(startOffset);
        int endLine = text.getLineOfOffset(endOffset);
        boolean dotsAdded = false;
        if (surroundLinesOnly && startOffset == 0) {
            startLine = Math.max(endLine - 1, 0);
            buf.append("...<br>");
            dotsAdded = true;
        }
        int i = startLine;
        while (i <= endLine) {
            if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                if (!dotsAdded) {
                    buf.append("...<br>");
                    dotsAdded = true;
                } else if (endOffset == text.getLength()) {
                    return;
                }
            } else {
                TextRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.getContent(from, to - from);
                if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                    buf.append(content);
                    if (to == end && to != endOffset) {
                        buf.append("<br>");
                    }
                }
            }
            ++i;
        }
    }

    public void apply(IDocument document) {
        try {
            ICompilationUnit unit = JavaModelUtil.toOriginal(this.getCompilationUnit());
            IStatus status = Resources.makeCommittable(unit.getResource(), null);
            if (!status.isOK()) {
                String label = CorrectionMessages.getString("CUCorrectionProposal.error.title");
                String message = CorrectionMessages.getString("CUCorrectionProposal.error.message");
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
                return;
            }
            CompilationUnitChange change = this.getCompilationUnitChange();
            GroupDescription selection = this.getSelectionDescription();
            GroupDescription[] linked = this.getLinkedRanges();
            IEditorPart part = null;
            if (selection != null || linked != null) {
                IWorkbenchPage page;
                change.setKeepExecutedTextEdits(true);
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null) {
                    part = EditorUtility.openInEditor(unit, true);
                }
                if ((page = JavaPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            super.apply(document);
            if (part == null) {
                return;
            }
            if (linked != null && part instanceof JavaEditor) {
                ISourceViewer viewer = ((JavaEditor)part).getViewer();
                this.enterLinkedMode(change, (ITextViewer)viewer, linked, selection);
            } else if (selection != null && part instanceof ITextEditor) {
                IRegion range = change.getNewTextRange(selection.getTextEdits());
                ((ITextEditor)part).selectAndReveal(range.getOffset(), range.getLength());
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private void enterLinkedMode(CompilationUnitChange change, ITextViewer viewer, GroupDescription[] linked, GroupDescription selection) throws BadLocationException {
        LinkedPositionGroup group;
        IDocument document = viewer.getDocument();
        HashMap<String, LinkedPositionGroup> map = new HashMap<String, LinkedPositionGroup>();
        int i = 0;
        while (i < linked.length) {
            IRegion range;
            GroupDescription curr = linked[i];
            String name = curr.getName();
            group = (LinkedPositionGroup)map.get(name);
            if (group == null) {
                group = new LinkedPositionGroup();
                map.put(name, group);
            }
            TextEdit[] textEdits = curr.getTextEdits();
            if (name != null && textEdits.length > 0 && (range = change.getNewTextRange(textEdits)) != null) {
                ICompletionProposal[] linkedModeProposals = this.getLinkedModeProposals(name);
                if (linkedModeProposals != null && linkedModeProposals.length > 1) {
                    group.createPosition(document, range.getOffset(), range.getLength(), i, linkedModeProposals);
                } else {
                    group.createPosition(document, range.getOffset(), range.getLength(), i);
                }
            }
            ++i;
        }
        LinkedEnvironment environment = new LinkedEnvironment();
        boolean added = false;
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            group = (LinkedPositionGroup)it.next();
            if (group.isEmtpy()) continue;
            environment.addGroup(group);
            added = true;
        }
        environment.forceInstall();
        if (added) {
            LinkedUIControl ui = new LinkedUIControl(environment, viewer);
            if (selection != null) {
                IRegion range;
                TextEdit[] textEdits = selection.getTextEdits();
                if (textEdits.length > 0 && (range = change.getNewTextRange(textEdits)) != null) {
                    ui.setExitPosition(viewer, range.getOffset() + range.getLength(), 0, true);
                }
            } else {
                int cursorPosition = viewer.getSelectedRange().x;
                if (cursorPosition != 0) {
                    ui.setExitPosition(viewer, cursorPosition, 0, true);
                }
            }
            ui.enter();
            IRegion region = ui.getSelectedRegion();
            viewer.setSelectedRange(region.getOffset(), region.getLength());
            viewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    public CompilationUnitChange getCompilationUnitChange() throws CoreException {
        return (CompilationUnitChange)this.getChange();
    }

    public TextEdit getRootTextEdit() {
        return this.fRootEdit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String toString() {
        try {
            CompilationUnitChange change = this.getCompilationUnitChange();
            return change.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

