/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.PreferenceConstants;

public class AssignToVariableAssistProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private final String KEY_NAME = "name";
    private final String KEY_TYPE = "type";
    private final int fVariableKind;
    private final ASTNode fNodeToAssign;
    private final ITypeBinding fTypeBinding;

    public AssignToVariableAssistProposal(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super(null, cu, null, relevance, null);
        this.fVariableKind = variableKind;
        this.fNodeToAssign = node;
        this.fTypeBinding = typeBinding;
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntolocal.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assigntofield.description"));
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
        }
    }

    public AssignToVariableAssistProposal(ICompilationUnit cu, SingleVariableDeclaration parameter, ITypeBinding typeBinding, int relevance) {
        super(null, cu, null, relevance, null);
        this.fVariableKind = 2;
        this.fNodeToAssign = parameter;
        this.fTypeBinding = typeBinding;
        this.setDisplayName(CorrectionMessages.getString("AssignToVariableAssistProposal.assignparamtofield.description"));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            return this.doAddField();
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() throws CoreException {
        Expression expression = ((ExpressionStatement)this.fNodeToAssign).getExpression();
        ASTRewrite rewrite = new ASTRewrite(this.fNodeToAssign.getParent());
        AST ast = this.fNodeToAssign.getAST();
        String varName = this.suggestLocalVariableNames(this.fTypeBinding);
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        newDeclFrag.setInitializer((Expression)rewrite.createCopy((ASTNode)expression));
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        rewrite.markAsReplaced(this.fNodeToAssign, (ASTNode)newDecl);
        this.markAsLinked(rewrite, (ASTNode)newDeclFrag.getName(), true, "name");
        this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, "type");
        this.markAsSelection(rewrite, (ASTNode)newDecl);
        return rewrite;
    }

    private ASTRewrite doAddField() throws CoreException {
        ASTNode selectionNode;
        Block body;
        boolean isParamToField = this.fNodeToAssign.getNodeType() == 44;
        ASTNode newTypeDecl = ASTResolving.findParentType(this.fNodeToAssign);
        if (newTypeDecl == null) {
            return null;
        }
        SimpleName expression = isParamToField ? ((SingleVariableDeclaration)this.fNodeToAssign).getName() : ((ExpressionStatement)this.fNodeToAssign).getExpression();
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        List decls = isAnonymous ? ((AnonymousClassDeclaration)newTypeDecl).bodyDeclarations() : ((TypeDeclaration)newTypeDecl).bodyDeclarations();
        ASTRewrite rewrite = new ASTRewrite(newTypeDecl);
        AST ast = newTypeDecl.getAST();
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(this.fNodeToAssign);
        if (bodyDecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)bodyDecl).getBody();
        } else if (bodyDecl instanceof Initializer) {
            body = ((Initializer)bodyDecl).getBody();
        } else {
            return null;
        }
        boolean isStatic = Modifier.isStatic((int)bodyDecl.getModifiers()) && !isAnonymous;
        int modifiers = 2;
        if (isStatic) {
            modifiers |= 8;
        }
        String varName = this.suggestFieldNames(this.fTypeBinding, (Expression)expression, modifiers);
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        newDecl.setModifiers(modifiers);
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide((Expression)rewrite.createCopy((ASTNode)expression));
        boolean needsThis = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.keywordthis");
        if (isParamToField) {
            needsThis |= varName.equals(expression.getIdentifier());
        }
        SimpleName accessName = ast.newSimpleName(varName);
        if (needsThis) {
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(accessName);
            if (isStatic) {
                String typeName = ((TypeDeclaration)newTypeDecl).getName().getIdentifier();
                fieldAccess.setExpression((Expression)ast.newSimpleName(typeName));
            } else {
                fieldAccess.setExpression((Expression)ast.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)accessName);
        }
        int insertIndex = this.findFieldInsertIndex(decls, this.fNodeToAssign.getStartPosition());
        rewrite.markAsInsertInOriginal(newTypeDecl, 5, (ASTNode)newDecl, insertIndex, null);
        if (isParamToField) {
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            int insertIdx = this.findAssignmentInsertIndex(body.statements());
            rewrite.markAsInsertInOriginal((ASTNode)body, 45, (ASTNode)statement, insertIdx, null);
            selectionNode = statement;
        } else {
            rewrite.markAsReplaced((ASTNode)expression, (ASTNode)assignment);
            selectionNode = this.fNodeToAssign;
        }
        this.markAsLinked(rewrite, (ASTNode)newDeclFrag.getName(), false, "name");
        this.markAsLinked(rewrite, (ASTNode)newDecl.getType(), false, "type");
        this.markAsLinked(rewrite, (ASTNode)accessName, true, "name");
        this.markAsSelection(rewrite, selectionNode);
        return rewrite;
    }

    private Type evaluateType(AST ast) throws CoreException {
        ITypeBinding[] proposals = ASTResolving.getRelaxingTypes(ast, this.fTypeBinding);
        int i = 0;
        while (i < proposals.length) {
            this.addLinkedModeProposal("type", proposals[i]);
            ++i;
        }
        String typeName = this.addImport(this.fTypeBinding);
        return ASTNodeFactory.newType(ast, typeName);
    }

    private String suggestLocalVariableNames(ITypeBinding binding) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = this.getUsedVariableNames();
        String typeName = base.getName();
        String[] names = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (String[])excludedNames);
        if (names.length == 0) {
            return "class1";
        }
        int i = 0;
        while (i < names.length) {
            this.addLinkedModeProposal("name", names[i]);
            ++i;
        }
        return names[0];
    }

    private String suggestFieldNames(ITypeBinding binding, Expression expression, int modifiers) {
        String typeName;
        String[] names;
        String curr;
        int i;
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = this.getUsedVariableNames();
        String result = null;
        HashSet<String> taken = new HashSet<String>();
        if (expression instanceof SimpleName) {
            String name = ((SimpleName)expression).getIdentifier();
            String[] argname = StubUtility.getFieldNameSuggestions(project, name, modifiers, excludedNames);
            i = 0;
            while (i < argname.length) {
                curr = argname[i];
                if (result == null || curr.length() > result.length()) {
                    result = curr;
                }
                if (taken.add(curr)) {
                    this.addLinkedModeProposal("name", curr);
                }
                ++i;
            }
        }
        if ((names = NamingConventions.suggestFieldNames((IJavaProject)project, (String)packName, (String)(typeName = base.getName()), (int)binding.getDimensions(), (int)modifiers, (String[])excludedNames)).length == 0) {
            return "class1";
        }
        i = 0;
        while (i < names.length) {
            curr = names[i];
            if (taken.add(curr)) {
                this.addLinkedModeProposal("name", curr);
            }
            ++i;
        }
        if (result == null) {
            result = names[0];
        }
        return result;
    }

    private String[] getUsedVariableNames() {
        CompilationUnit root = (CompilationUnit)this.fNodeToAssign.getRoot();
        IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsInScope(this.fNodeToAssign.getStartPosition(), 2);
        String[] names = new String[bindings.length];
        int i = 0;
        while (i < names.length) {
            names[i] = bindings[i].getName();
            ++i;
        }
        return names;
    }

    private int findAssignmentInsertIndex(List statements) {
        HashSet<String> paramsBefore = new HashSet<String>();
        List params = ((MethodDeclaration)this.fNodeToAssign.getParent()).parameters();
        int i = 0;
        while (i < params.size() && params.get(i) != this.fNodeToAssign) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i);
            paramsBefore.add(decl.getName().getIdentifier());
            ++i;
        }
        i = 0;
        i = 0;
        while (i < statements.size()) {
            Statement curr = (Statement)statements.get(i);
            switch (curr.getNodeType()) {
                case 17: 
                case 46: {
                    break;
                }
                case 21: {
                    IVariableBinding binding;
                    Assignment assignment;
                    Expression rightHand;
                    Expression expr = ((ExpressionStatement)curr).getExpression();
                    if (expr instanceof Assignment && (rightHand = (assignment = (Assignment)expr).getRightHandSide()) instanceof SimpleName && paramsBefore.contains(((SimpleName)rightHand).getIdentifier()) && ((binding = Bindings.getAssignedVariable(assignment)) == null || binding.isField())) break;
                    return i;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int findFieldInsertIndex(List decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

