/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.Modifier;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddArgumentCorrectionProposal
extends LinkedCorrectionProposal {
    private int[] fInsertIndexes;
    private ITypeBinding[] fParamTypes;
    private ASTNode fCallerNode;

    public AddArgumentCorrectionProposal(String label, ICompilationUnit cu, ASTNode callerNode, int[] insertIdx, ITypeBinding[] expectedTypes, int relevance) {
        super(label, cu, null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fCallerNode = callerNode;
        this.fInsertIndexes = insertIdx;
        this.fParamTypes = expectedTypes;
    }

    protected ASTRewrite getRewrite() {
        AST ast = this.fCallerNode.getAST();
        ASTRewrite rewrite = new ASTRewrite(this.fCallerNode);
        int i = 0;
        while (i < this.fInsertIndexes.length) {
            int idx = this.fInsertIndexes[i];
            String key = "newarg_" + i;
            Expression newArg = this.evaluateArgumentExpressions(ast, this.fParamTypes[idx], key);
            rewrite.markAsInsertInNew(this.fCallerNode, 2, (ASTNode)newArg, idx, null);
            this.markAsLinked(rewrite, (ASTNode)newArg, i == 0, key);
            ++i;
        }
        return rewrite;
    }

    private Expression evaluateArgumentExpressions(AST ast, ITypeBinding requiredType, String key) {
        CompilationUnit root = (CompilationUnit)this.fCallerNode.getRoot();
        int offset = this.fCallerNode.getStartPosition();
        Expression best = null;
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        IBinding[] bindings = analyzer.getDeclarationsInScope(offset, 2);
        int i = 0;
        while (i < bindings.length) {
            IVariableBinding curr = (IVariableBinding)bindings[i];
            ITypeBinding type = curr.getType();
            if (type != null && TypeRules.canAssign(type, requiredType) && this.testModifier(curr)) {
                if (best == null) {
                    best = ast.newSimpleName(curr.getName());
                }
                this.addLinkedModeProposal(key, curr.getName());
            }
            ++i;
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, requiredType);
        if (best == null) {
            best = defaultExpression;
        }
        this.addLinkedModeProposal(key, ASTNodes.asString((ASTNode)defaultExpression));
        return best;
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic(modifiers) || ASTResolving.isInStaticContext(this.fCallerNode);
    }
}

