/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.ICommentTagConstants;
import org.eclipse.jface.text.TypedPosition;

public class MultiCommentRegion
extends CommentRegion
implements ICommentTagConstants {
    private final boolean fIndentDescriptions;
    private final boolean fIndentRoots;
    private final boolean fParameterNewLine;
    private boolean fSeparateRoots;

    protected MultiCommentRegion(CommentFormattingStrategy strategy, TypedPosition position, String delimiter) {
        super(strategy, position, delimiter);
        Map preferences = strategy.getPreferences();
        this.fIndentRoots = "true".equals(preferences.get("comment_indent_root_tags"));
        this.fIndentDescriptions = "true".equals(preferences.get("comment_indent_parameter_description"));
        this.fSeparateRoots = "true".equals(preferences.get("comment_separate_root_tags"));
        this.fParameterNewLine = "true".equals(preferences.get("comment_new_line_for_parameter"));
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int position, int count) {
        boolean blank = next.hasAttribute(2);
        if (next.getLength() <= 2 && !blank && !this.isCommentWord(next)) {
            return true;
        }
        if (this.fParameterNewLine && line.hasAttribute(1024) && line.getSize() > 1) {
            return false;
        }
        if (previous != null) {
            if (previous.hasAttribute(2048)) {
                return true;
            }
            if (position != 0 && (blank || previous.hasAttribute(2) || next.hasAttribute(1024) || next.hasAttribute(2048) || next.hasAttribute(4096) || next.hasAttribute(128) || previous.hasAttribute(4) || previous.hasAttribute(4096))) {
                return false;
            }
            if (next.hasAttribute(64) && previous.hasAttribute(64)) {
                return true;
            }
        }
        if (this.fIndentRoots && !line.hasAttribute(2048) && !line.hasAttribute(1024)) {
            count -= this.stringToLength(line.getIndentation());
        }
        return super.canAppend(line, previous, next, position, count);
    }

    protected String getDelimiter(CommentLine predecessor, CommentLine successor, CommentRange previous, CommentRange next, String indentation) {
        String delimiter = super.getDelimiter(predecessor, successor, previous, next, indentation);
        if (previous != null) {
            if (previous.hasAttribute(4160) && !next.hasAttribute(16) && !successor.hasAttribute(2)) {
                return String.valueOf(delimiter) + delimiter;
            }
            if (previous.hasAttribute(16) && !next.hasAttribute(16)) {
                return this.getDelimiter();
            }
            if ((next.hasAttribute(4160) || (this.fSeparateRoots || !this.isClearLines()) && previous.hasAttribute(512)) && !successor.hasAttribute(2)) {
                return String.valueOf(delimiter) + delimiter;
            }
            if (this.fIndentRoots && !predecessor.hasAttribute(2048) && !predecessor.hasAttribute(1024) && !predecessor.hasAttribute(2)) {
                return String.valueOf(delimiter) + this.stringToIndent(predecessor.getIndentation(), false);
            }
        }
        return delimiter;
    }

    protected String getDelimiter(CommentRange previous, CommentRange next) {
        if (previous != null) {
            if (previous.hasAttribute(32) && next.hasAttribute(32)) {
                return "";
            }
            if (next.hasAttribute(256) || previous.hasAttribute(40)) {
                return "";
            }
            if (!next.hasAttribute(16) && previous.hasAttribute(16)) {
                return "";
            }
            if (next.hasAttribute(8) && previous.getLength() <= 2 && !this.isCommentWord(previous)) {
                return "";
            }
            if (previous.hasAttribute(256) && next.getLength() <= 2 && !this.isCommentWord(next)) {
                return "";
            }
        }
        return super.getDelimiter(previous, next);
    }

    protected final boolean isIndentDescriptions() {
        return this.fIndentDescriptions;
    }

    protected final boolean isIndentRoots() {
        return this.fIndentRoots;
    }

    protected void markHtmlRanges() {
    }

    protected void markHtmlTag(CommentRange range, String token) {
    }

    protected void markJavadocTag(CommentRange range, String token) {
        range.markPrefixTag(ICommentTagConstants.COMMENT_ROOT_TAGS, '@', token, 2048);
    }

    protected final void markRegion() {
        int count = 0;
        boolean paragraph = false;
        String token = null;
        CommentRange range = null;
        CommentRange blank = null;
        ListIterator iterator = this.getRanges().listIterator();
        while (iterator.hasNext()) {
            range = (CommentRange)iterator.next();
            count = range.getLength();
            if (count <= 0) continue;
            token = this.getText(range.getOffset(), count).toLowerCase();
            this.markJavadocTag(range, token);
            if (!paragraph && (range.hasAttribute(2048) || range.hasAttribute(1024))) {
                iterator.previous();
                while (iterator.hasPrevious()) {
                    blank = (CommentRange)iterator.previous();
                    if (!blank.hasAttribute(2)) break;
                    iterator.remove();
                }
                range.setAttribute(512);
                paragraph = true;
            }
            this.markHtmlTag(range, token);
        }
        this.markHtmlRanges();
    }
}

