/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.ICommentAttributes;
import org.eclipse.jdt.internal.ui.text.comment.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.comment.ILinkTagConstants;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentRegion;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class MultiCommentLine
extends CommentLine
implements ICommentAttributes,
IHtmlTagConstants,
ILinkTagConstants {
    public static final String MULTI_COMMENT_CONTENT_PREFIX = " * ";
    public static final String MULTI_COMMENT_END_PREFIX = " */";
    public static final String MULTI_COMMENT_START_PREFIX = "/* ";
    private String fIndentation = "";

    protected MultiCommentLine(CommentRegion region) {
        super(region);
    }

    protected void adapt(CommentLine previous) {
        if (!(this.hasAttribute(2048) || this.hasAttribute(1024) || previous.hasAttribute(2))) {
            this.fIndentation = previous.getIndentation();
        }
    }

    protected void append(CommentRange range) {
        MultiCommentRegion parent = (MultiCommentRegion)this.getParent();
        if (range.hasAttribute(1024)) {
            this.setAttribute(1024);
        } else if (range.hasAttribute(2048)) {
            this.setAttribute(2048);
        } else if (range.hasAttribute(2)) {
            this.setAttribute(2);
        }
        int ranges = this.getSize();
        if (ranges == 1 && parent.isIndentRoots()) {
            CommentRange first = this.getFirst();
            String common = String.valueOf(parent.getText(first.getOffset(), first.getLength())) + " ";
            if (this.hasAttribute(2048)) {
                this.fIndentation = common;
            } else if (this.hasAttribute(1024)) {
                this.fIndentation = parent.isIndentDescriptions() ? String.valueOf(common) + "\t" : common;
            }
        }
        super.append(range);
    }

    protected String getContentPrefix() {
        return MULTI_COMMENT_CONTENT_PREFIX;
    }

    protected String getEndingPrefix() {
        return MULTI_COMMENT_END_PREFIX;
    }

    protected final String getIndentation() {
        return this.fIndentation;
    }

    protected String getStartingPrefix() {
        return MULTI_COMMENT_START_PREFIX;
    }

    protected void scanLine(int line) {
        CommentRegion parent = this.getParent();
        String start = this.getStartingPrefix().trim();
        String end = this.getEndingPrefix().trim();
        String content = this.getContentPrefix().trim();
        int lines = parent.getSize();
        CommentRange range = this.getFirst();
        int offset = 0;
        int postfix = 0;
        String text = parent.getText(range.getOffset(), range.getLength());
        if (line == 0) {
            offset = text.indexOf(start);
            if (offset >= 0) {
                range.trimBegin(offset += start.length());
                postfix = text.lastIndexOf(end);
                if (postfix > offset) {
                    range.setLength(postfix - offset);
                } else {
                    postfix = text.lastIndexOf(content);
                    if (postfix >= offset) {
                        range.setLength(postfix - offset);
                        parent.setBorder(2);
                        if (postfix > offset) {
                            text = parent.getText(range.getOffset(), range.getLength());
                            IRegion region = this.trimLine(text, content);
                            range.move(region.getOffset());
                            range.setLength(region.getLength());
                        }
                    }
                }
            }
        } else if (line == lines - 1) {
            offset = text.indexOf(content);
            if (offset >= 0) {
                range.trimBegin(offset + 1);
                if (text.startsWith(end, offset)) {
                    range.setLength(0);
                } else {
                    postfix = text.lastIndexOf(end);
                    if (postfix > offset) {
                        range.trimEnd(-end.length());
                        text = parent.getText(range.getOffset(), range.getLength());
                        IRegion region = this.trimLine(text, content);
                        if (region.getOffset() != 0 || region.getLength() != text.length()) {
                            range.move(region.getOffset());
                            range.setLength(region.getLength());
                            parent.setBorder(2);
                            parent.setBorder(1);
                        }
                    }
                }
            }
        } else {
            offset = text.indexOf(content);
            if (offset >= 0) {
                range.trimBegin(offset += content.length());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void tokenizeLine(int line) {
        index = offset = 0;
        parent = this.getParent();
        range = this.getFirst();
        begin = range.getOffset();
        content = parent.getText(begin, range.getLength());
        length = content.length();
        while (offset < length && Character.isWhitespace(content.charAt(offset))) {
            ++offset;
        }
        result = null;
        if (offset >= length && !parent.isClearLines() && line > 0 && line < parent.getSize() - 1) {
            result = new CommentRange(begin, 0);
            result.setAttribute(2);
            parent.append(result);
        }
        attribute = 0;
        ** GOTO lbl48
        {
            ++offset;
            do {
                block9: {
                    block10: {
                        if (offset < length && Character.isWhitespace(content.charAt(offset))) continue block1;
                        attribute = 0;
                        index = offset;
                        if (index >= length) break block9;
                        if (content.charAt(index) != '<') break block10;
                        while (index < length && content.charAt(index) != '>') {
                            ++index;
                        }
                        if (index < length && content.charAt(index) == '>') {
                            ++index;
                        }
                        attribute = 32;
                        break block9;
                    }
                    if (!content.startsWith("{@", index)) ** GOTO lbl41
                    while (index < length && content.charAt(index) != '}') {
                        ++index;
                    }
                    if (index < length && content.charAt(index) == '}') {
                        ++index;
                    }
                    attribute = 264;
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        ++index;
lbl41:
                        // 2 sources

                        ** while (index < length && !Character.isWhitespace((char)content.charAt((int)index)) && content.charAt((int)index) != '<' && !content.startsWith((String)"{@", (int)index))
                    }
                }
                if (index - offset <= 0) continue;
                result = new CommentRange(begin + offset, index - offset);
                result.setAttribute(attribute);
                parent.append(result);
                offset = index;
lbl48:
                // 3 sources

            } while (offset < length);
        }
    }

    protected final IRegion trimLine(String line, String trimmable) {
        int trim = trimmable.length();
        int offset = 0;
        int length = line.length() - trim;
        while (line.startsWith(trimmable, offset)) {
            offset += trim;
        }
        while (line.startsWith(trimmable, length)) {
            length -= trim;
        }
        return new Region(offset, length + trim);
    }
}

